/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.technomancy;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.beams.IBeamHandler;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.packets.SendPlayerTickCountToClient;
import com.Da_Technomancer.crossroads.API.technomancy.FluxUtil;
import com.Da_Technomancer.crossroads.API.technomancy.IFluxLink;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.blocks.technomancy.TemporalAccelerator;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class TemporalAcceleratorTileEntity
extends TileEntity
implements ITickableTileEntity,
IFluxLink {
    @ObjectHolder(value="temporal_accelerator")
    private static TileEntityType<TemporalAcceleratorTileEntity> type = null;
    public static final int FLUX_MULT = 2;
    public static final int SIZE = 5;
    private int flux = 0;
    private int fluxToTrans = 0;
    private final HashSet<BlockPos> linkPos = new HashSet(1);
    private int intensity = 0;
    private long lastRunTick;
    private Direction facing;
    private TemporalAccelerator.Mode mode;
    private LazyOptional<IBeamHandler> beamOpt = LazyOptional.of(() -> new BeamHandler());

    public TemporalAcceleratorTileEntity() {
        super(type);
    }

    public void resetCache() {
        this.facing = null;
        this.mode = null;
        this.beamOpt.invalidate();
        this.beamOpt = LazyOptional.of(() -> new BeamHandler());
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.time_accel.boost", new Object[]{100 * this.extraTicks()}));
        FluxUtil.addFluxInfo(chat, this, this.producedFlux());
        FluxUtil.addLinkInfo(chat, this);
    }

    private int extraTicks() {
        return this.intensity / 4;
    }

    private int producedFlux() {
        int boost = this.extraTicks();
        if (boost > 0) {
            return (int)Math.pow(2.0, boost) * 2;
        }
        return 0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_186662_g((double)this.getRange());
    }

    public void receiveLong(byte identifier, long message, @Nullable ServerPlayerEntity sendingPlayer) {
        if (identifier == 8) {
            this.linkPos.add(BlockPos.func_218283_e((long)message));
            this.func_70296_d();
        } else if (identifier == 9) {
            this.linkPos.clear();
            this.func_70296_d();
        }
    }

    private Direction getFacing() {
        if (this.facing == null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof TemporalAccelerator)) {
                this.func_145843_s();
                return Direction.DOWN;
            }
            this.facing = (Direction)state.func_177229_b((IProperty)ESProperties.FACING);
            this.mode = (TemporalAccelerator.Mode)((Object)state.func_177229_b(CRProperties.ACCELERATOR_TARGET));
        }
        return this.facing;
    }

    private TemporalAccelerator.Mode getMode() {
        if (this.facing == null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof TemporalAccelerator)) {
                this.func_145843_s();
                return TemporalAccelerator.Mode.ENTITIES;
            }
            this.facing = (Direction)state.func_177229_b((IProperty)ESProperties.FACING);
            this.mode = (TemporalAccelerator.Mode)((Object)state.func_177229_b(CRProperties.ACCELERATOR_TARGET));
        }
        return this.mode;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() != this.lastRunTick) {
            this.lastRunTick = this.field_145850_b.func_82737_E();
            int extraTicks = this.extraTicks();
            long stage = this.field_145850_b.func_82737_E() % 4L;
            if (stage == 0L) {
                this.addFlux(this.producedFlux());
                this.intensity = 0;
                this.fluxToTrans += this.flux;
                this.flux = 0;
            } else if (stage == 1L) {
                this.flux += FluxUtil.performTransfer(this, this.linkPos, this.fluxToTrans);
                this.fluxToTrans = 0;
                FluxUtil.checkFluxOverload(this);
            }
            TemporalAccelerator.Mode mode = this.getMode();
            if (extraTicks > 0) {
                boolean actOnTe;
                BlockPos endPos;
                BlockPos startPos;
                switch (this.getFacing()) {
                    case DOWN: {
                        startPos = this.field_174879_c.func_177982_a(-2, -5, -2);
                        endPos = this.field_174879_c.func_177982_a(3, 0, 3);
                        break;
                    }
                    case UP: {
                        startPos = this.field_174879_c.func_177982_a(-2, 1, -2);
                        endPos = this.field_174879_c.func_177982_a(3, 6, 3);
                        break;
                    }
                    case NORTH: {
                        startPos = this.field_174879_c.func_177982_a(-2, -2, -5);
                        endPos = this.field_174879_c.func_177982_a(3, 3, 0);
                        break;
                    }
                    case SOUTH: {
                        startPos = this.field_174879_c.func_177982_a(-2, -2, 1);
                        endPos = this.field_174879_c.func_177982_a(3, 3, 6);
                        break;
                    }
                    case WEST: {
                        startPos = this.field_174879_c.func_177982_a(-5, -2, -2);
                        endPos = this.field_174879_c.func_177982_a(0, 3, 3);
                        break;
                    }
                    default: {
                        startPos = this.field_174879_c.func_177982_a(1, -2, -2);
                        endPos = this.field_174879_c.func_177982_a(6, 3, 3);
                    }
                }
                if (mode.accelerateEntities) {
                    AxisAlignedBB bb = new AxisAlignedBB(startPos, endPos);
                    ArrayList ents = (ArrayList)this.field_145850_b.func_217357_a(Entity.class, bb);
                    for (Entity ent : ents) {
                        if (ent instanceof ServerPlayerEntity) {
                            CRPackets.sendPacketToPlayer((ServerPlayerEntity)ent, new SendPlayerTickCountToClient(extraTicks + 1));
                        }
                        for (int i = 0; i < extraTicks; ++i) {
                            ent.func_70071_h_();
                        }
                    }
                }
                boolean bl = actOnTe = mode.accelerateTileEntities && (Boolean)CRConfig.teTimeAccel.get() != false;
                if (actOnTe || mode.accelerateBlockTicks) {
                    for (int x = startPos.func_177958_n(); x < endPos.func_177958_n(); ++x) {
                        for (int y = startPos.func_177956_o(); y < endPos.func_177956_o(); ++y) {
                            for (int z = startPos.func_177952_p(); z < endPos.func_177952_p(); ++z) {
                                BlockState state;
                                TileEntity te;
                                BlockPos effectPos = new BlockPos(x, y, z);
                                if (actOnTe && (te = this.field_145850_b.func_175625_s(effectPos)) instanceof ITickableTileEntity) {
                                    for (int run = 0; run < extraTicks; ++run) {
                                        ((ITickableTileEntity)te).func_73660_a();
                                    }
                                }
                                if (!mode.accelerateBlockTicks || !(state = this.field_145850_b.func_180495_p(effectPos)).func_204519_t() || this.field_145850_b.field_73012_v.nextInt(4096 / this.field_145850_b.func_82736_K().func_223592_c(GameRules.field_223610_m)) >= extraTicks) continue;
                                state.func_196944_b(this.field_145850_b, effectPos, this.field_145850_b.field_73012_v);
                            }
                        }
                    }
                }
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.beamOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.BEAM_CAPABILITY && (side == null || side == this.getFacing().func_176734_d())) {
            return this.beamOpt;
        }
        return super.getCapability(cap, side);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("intensity", this.intensity);
        nbt.func_74772_a("last_run", this.lastRunTick);
        nbt.func_74768_a("flux", this.flux);
        nbt.func_74768_a("flux_trans", this.fluxToTrans);
        for (BlockPos linked : this.linkPos) {
            nbt.func_74772_a("link", linked.func_218275_a());
        }
        return nbt;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.intensity = nbt.func_74762_e("intensity");
        this.lastRunTick = nbt.func_74763_f("last_run");
        this.flux = nbt.func_74762_e("flux");
        this.fluxToTrans = nbt.func_74762_e("flux_trans");
        if (nbt.func_74764_b("link")) {
            this.linkPos.add(BlockPos.func_218283_e((long)nbt.func_74763_f("link")));
        } else {
            this.linkPos.clear();
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        for (BlockPos linked : this.linkPos) {
            nbt.func_74772_a("link", linked.func_218275_a());
        }
        return nbt;
    }

    @Override
    public int getFlux() {
        return this.flux;
    }

    @Override
    public void setFlux(int newFlux) {
        this.flux = newFlux;
        this.func_70296_d();
    }

    public Set<BlockPos> getLinks() {
        return this.linkPos;
    }

    private class BeamHandler
    implements IBeamHandler {
        private BeamHandler() {
        }

        @Override
        public void setBeam(BeamUnit mag) {
            if (mag != null && EnumBeamAlignments.getAlignment(mag) == EnumBeamAlignments.TIME) {
                if (mag.getVoid() == 0) {
                    TemporalAcceleratorTileEntity.this.intensity += mag.getPower();
                } else {
                    TemporalAcceleratorTileEntity.this.intensity -= mag.getPower();
                }
                TemporalAcceleratorTileEntity.this.func_70296_d();
            }
        }
    }
}

