/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.world;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class SingleGen
extends Feature<SingleOreConfig> {
    protected SingleGen() {
        super(SingleOreConfig::deserialize);
    }

    public boolean place(IWorld worldIn, ChunkGenerator generator, Random rand, BlockPos pos, SingleOreConfig config) {
        BlockState state = worldIn.func_180495_p(pos);
        if (config.target.getPred().test(state)) {
            worldIn.func_180501_a(pos, config.state, 2);
            return true;
        }
        return false;
    }

    public static class SingleOreConfig
    implements IFeatureConfig {
        public final CRFillerType target;
        public final BlockState state;

        public SingleOreConfig(CRFillerType target, BlockState state) {
            this.state = state;
            this.target = target;
        }

        public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
            return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("target"), (Object)ops.createString(this.target.name()), (Object)ops.createString("state"), (Object)BlockState.func_215689_a(ops, (BlockState)this.state).getValue())));
        }

        public static SingleOreConfig deserialize(Dynamic<?> dyn) {
            CRFillerType fillType = CRFillerType.valueOf(dyn.get("target").asString(""));
            BlockState blockstate = dyn.get("state").map(BlockState::func_215698_a).orElse(Blocks.field_150350_a.func_176223_P());
            return new SingleOreConfig(fillType, blockstate);
        }

        public static enum CRFillerType {
            NATURAL_STONE(state -> {
                if (state == null) {
                    return false;
                }
                Block block = state.func_177230_c();
                return block == Blocks.field_150348_b || block == Blocks.field_196650_c || block == Blocks.field_196654_e || block == Blocks.field_196656_g;
            }),
            QUARTZ((Predicate<BlockState>)new BlockMatcher(Blocks.field_196766_fg)),
            END_STONE((Predicate<BlockState>)new BlockMatcher(Blocks.field_150377_bs));

            private final Predicate<BlockState> matched;

            private CRFillerType(Predicate<BlockState> matched) {
                this.matched = matched;
            }

            public Predicate<BlockState> getPred() {
                return this.matched;
            }
        }
    }
}

