/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API;

import com.Da_Technomancer.crossroads.Crossroads;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AdvancementTracker {
    private static final HashMap<String, Boolean> progressMap = new HashMap(16);

    @OnlyIn(value=Dist.CLIENT)
    public static void listen() {
        Minecraft.func_71410_x().field_71439_g.field_71174_a.func_191982_f().func_192798_a((ClientAdvancementManager.IListener)Listener.INSTANCE);
    }

    public static boolean hasAdvancement(PlayerEntity ent, String advancement) {
        if (ent instanceof ServerPlayerEntity) {
            return ((ServerPlayerEntity)ent).func_192039_O().func_192747_a(ent.field_70170_p.func_73046_m().func_191949_aK().func_192778_a(new ResourceLocation("crossroads", advancement))).func_192105_a();
        }
        if (ent instanceof ClientPlayerEntity) {
            return progressMap.getOrDefault(advancement, false);
        }
        Crossroads.logger.error("Advancement fetch on illegal entity type: " + (ent == null ? "NULL" : ent.toString()) + "; with advancement: " + advancement + "; Report to mod author");
        return false;
    }

    public static void unlockAdvancement(ServerPlayerEntity ent, String advancement, boolean enabled) {
        PlayerAdvancements playAdv = ent.func_192039_O();
        Advancement adv = ent.field_70170_p.func_73046_m().func_191949_aK().func_192778_a(new ResourceLocation("crossroads", advancement));
        if (adv == null) {
            return;
        }
        AdvancementProgress prog = playAdv.func_192747_a(adv);
        if (enabled) {
            for (String s : prog.func_192107_d()) {
                playAdv.func_192750_a(adv, s);
            }
        } else {
            for (String s : prog.func_192102_e()) {
                playAdv.func_192744_b(adv, s);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Listener
    implements ClientAdvancementManager.IListener {
        private static final Listener INSTANCE = new Listener();

        private Listener() {
        }

        public void func_191933_a(Advancement advancementIn, AdvancementProgress progress) {
            ResourceLocation id = advancementIn.func_192067_g();
            if (id.func_110624_b().equals("crossroads")) {
                progressMap.put(id.func_110623_a(), progress.func_192105_a());
            }
        }

        public void func_193982_e(@Nullable Advancement advancementIn) {
        }

        public void func_191931_a(Advancement advancementIn) {
        }

        public void func_191928_b(Advancement advancementIn) {
        }

        public void func_191932_c(Advancement advancementIn) {
        }

        public void func_191929_d(Advancement advancementIn) {
        }

        public void func_191930_a() {
            progressMap.clear();
        }
    }
}

