/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API;

import com.Da_Technomancer.crossroads.API.AdvancementTracker;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.CRConfig;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;

public enum EnumPath {
    TECHNOMANCY(0),
    ALCHEMY(1),
    WITCHCRAFT(2);

    private final byte index;

    private EnumPath(byte ind) {
        this.index = ind;
    }

    public byte getIndex() {
        return this.index;
    }

    public static EnumPath fromIndex(byte ind) {
        return EnumPath.values()[ind];
    }

    public String toString() {
        return this.name().toLowerCase(Locale.US);
    }

    @Nullable
    public static EnumPath fromName(String name) {
        try {
            return EnumPath.valueOf(name.toUpperCase(Locale.US));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isUnlocked(PlayerEntity player) {
        return AdvancementTracker.hasAdvancement(player, "progress/path/" + this.toString());
    }

    public void setUnlocked(PlayerEntity player, boolean unlocked) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        AdvancementTracker.unlockAdvancement((ServerPlayerEntity)player, "progress/path/" + this.toString(), unlocked);
    }

    public boolean pathGatePassed(PlayerEntity player) {
        boolean multiplayer = player.field_70170_p.field_72995_K ? !Minecraft.func_71410_x().func_71356_B() : player.field_70170_p.func_73046_m().func_71262_S();
        if (multiplayer ? (Boolean)CRConfig.allowAllServer.get() == false : (Boolean)CRConfig.allowAllSingle.get() == false) {
            for (Enum enum_ : EnumPath.values()) {
                if (!((EnumPath)enum_).isUnlocked(player)) continue;
                return false;
            }
        }
        for (Enum enum_ : EnumBeamAlignments.values()) {
            if (enum_ == EnumBeamAlignments.VOID || enum_ == EnumBeamAlignments.NO_MATCH || ((EnumBeamAlignments)enum_).isDiscovered(player)) continue;
            return false;
        }
        return true;
    }
}

