/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.beams;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.beams.BeamUtil;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.beams.IBeamHandler;
import com.Da_Technomancer.crossroads.API.effects.BeamEffect;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Triple;

public class BeamManager {
    private final Direction dir;
    private final BlockPos pos;
    private int dist;
    @Nonnull
    private BeamUnit lastSent = BeamUnit.EMPTY;

    public BeamManager(@Nonnull Direction dir, @Nonnull BlockPos pos) {
        this.dir = dir;
        this.pos = pos.func_185334_h();
    }

    public boolean emit(@Nonnull BeamUnit mag, World world) {
        for (int i = 1; i <= 16; ++i) {
            LazyOptional opt;
            TileEntity checkTE = world.func_175625_s(this.pos.func_177967_a(this.dir, i));
            if (checkTE != null && (opt = checkTE.getCapability(Capabilities.BEAM_CAPABILITY, this.dir.func_176734_d())).isPresent()) {
                ((IBeamHandler)opt.orElseThrow(NullPointerException::new)).setBeam(mag);
                if (this.dist != i || !mag.equals(this.lastSent)) {
                    this.dist = i;
                    this.lastSent = mag;
                    return true;
                }
                return false;
            }
            BlockState checkState = world.func_180495_p(this.pos.func_177967_a(this.dir, i));
            if (i != 16 && !BeamUtil.solidToBeams(checkState, world, this.pos.func_177967_a(this.dir, i), this.dir, mag.getPower())) continue;
            if (!mag.isEmpty()) {
                EnumBeamAlignments align = EnumBeamAlignments.getAlignment(mag);
                BeamEffect e = align.getEffect();
                e.doBeamEffect(align, mag.getVoid() != 0, Math.min(64, mag.getPower()), world, this.pos.func_177967_a(this.dir, i), this.dir.func_176734_d());
            }
            if (this.dist != i || !mag.equals(this.lastSent)) {
                this.dist = i;
                this.lastSent = mag;
                return true;
            }
            return false;
        }
        return false;
    }

    public static int toPacket(BeamUnit mag, int dist) {
        if (mag == null) {
            return 0;
        }
        int packet = 0;
        if (mag.getPower() != 0) {
            packet |= mag.getRGB().getRGB() & 0xFFFFFF;
            packet |= (dist - 1 & 0xF) << 24;
            packet |= (BeamUtil.getBeamRadius(mag.getPower()) - 1 & 0xF) << 28;
        }
        return packet;
    }

    public int genPacket() {
        return BeamManager.toPacket(this.lastSent, this.dist);
    }

    public static Triple<Color, Integer, Integer> getTriple(int packet) {
        return packet == 0 ? Triple.of((Object)Color.BLACK, (Object)0, (Object)0) : Triple.of((Object)Color.decode(Integer.toString(packet & 0xFFFFFF)), (Object)((packet >>> 24 & 0xF) + 1), (Object)((packet >>> 28) + 1));
    }

    @Nonnull
    public BeamUnit getLastSent() {
        return this.lastSent;
    }
}

