/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.beams;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import java.awt.Color;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;

public class BeamUnit {
    public static final BeamUnit EMPTY = new BeamUnit(0, 0, 0, 0);
    private final int[] contents = new int[4];

    public BeamUnit(int[] magic) {
        this(magic[0], magic[1], magic[2], magic[3]);
    }

    public BeamUnit(int energy, int potential, int stability, int voi) {
        this.contents[0] = energy;
        this.contents[1] = potential;
        this.contents[2] = stability;
        this.contents[3] = voi;
        if (energy < 0 || potential < 0 || stability < 0 || voi < 0) {
            throw new IllegalArgumentException("Negative BeamUnit input! EN: " + energy + "; PO: " + potential + "; ST: " + stability + "; VO: " + voi);
        }
    }

    public int getEnergy() {
        return this.contents[0];
    }

    public int getPotential() {
        return this.contents[1];
    }

    public int getStability() {
        return this.contents[2];
    }

    public int getVoid() {
        return this.contents[3];
    }

    public int getPower() {
        return this.contents[0] + this.contents[1] + this.contents[2] + this.contents[3];
    }

    public boolean isEmpty() {
        return this.contents[0] == 0 && this.contents[1] == 0 && this.contents[2] == 0 && this.contents[3] == 0;
    }

    public int[] getValues() {
        return Arrays.copyOf(this.contents, 4);
    }

    public Color getTrueRGB() {
        if (this.contents[0] == 0 && this.contents[1] == 0 && this.contents[2] == 0) {
            return null;
        }
        double top = Math.max(this.contents[0], Math.max(this.contents[1], this.contents[2]));
        return new Color((int)Math.round(255.0 * (double)this.contents[0] / top), (int)Math.round(255.0 * (double)this.contents[1] / top), (int)Math.round(255.0 * (double)this.contents[2] / top));
    }

    public Color getRGB() {
        if (this.getTrueRGB() == null) {
            return Color.BLACK;
        }
        double mult = (double)(this.contents[0] + this.contents[1] + this.contents[2]) / (double)this.getPower();
        Color col = this.getTrueRGB();
        return new Color((int)Math.round((double)col.getRed() * mult), (int)Math.round((double)col.getGreen() * mult), (int)Math.round((double)col.getBlue() * mult));
    }

    public BeamUnit mult(double multiplier, boolean floor) {
        return this.mult(multiplier, multiplier, multiplier, multiplier, floor);
    }

    public BeamUnit mult(double e, double p, double s, double v, boolean floor) {
        return floor ? new BeamUnit((int)Math.floor(e * (double)this.contents[0]), (int)Math.floor(p * (double)this.contents[1]), (int)Math.floor(s * (double)this.contents[2]), (int)Math.floor(v * (double)this.contents[3])) : new BeamUnit(MiscUtil.safeRound(e * (double)this.contents[0]), MiscUtil.safeRound(p * (double)this.contents[1]), MiscUtil.safeRound(s * (double)this.contents[2]), MiscUtil.safeRound(v * (double)this.contents[3]));
    }

    public String toString() {
        if (this.isEmpty()) {
            return "En: 0; Po: 0; St: 0; Vo: 0";
        }
        Color col = this.getRGB();
        return EnumBeamAlignments.getAlignment(this).getLocalName(this.contents[3] != 0) + "-R: " + col.getRed() + ", G: " + col.getGreen() + ", B: " + col.getBlue() + "-En: " + this.contents[0] + ", Po: " + this.contents[1] + ", St: " + this.contents[2] + ", Vo: " + this.contents[3];
    }

    public boolean equals(Object other) {
        if (other instanceof BeamUnit) {
            BeamUnit o = (BeamUnit)other;
            return o == this || o.contents[0] == this.contents[0] && o.contents[1] == this.contents[1] && o.contents[2] == this.contents[2] && o.contents[3] == this.contents[3];
        }
        return false;
    }

    public int hashCode() {
        return ((this.contents[0] & 0xFF) << 24) + ((this.contents[1] & 0xFF) << 16) + ((this.contents[2] & 0xFF) << 8) + (this.contents[3] & 0xFF);
    }

    public void writeToNBT(@Nonnull String key, CompoundNBT nbt) {
        nbt.func_74783_a(key, this.contents);
    }

    public static BeamUnit readFromNBT(@Nonnull String key, CompoundNBT nbt) {
        if (nbt.func_74764_b(key)) {
            return new BeamUnit(nbt.func_74759_k(key));
        }
        return EMPTY;
    }
}

