/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.beams;

import com.Da_Technomancer.crossroads.CRConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BeamUtil {
    public static final int MAX_DISTANCE = 16;
    public static final int BEAM_TIME = 4;
    private static final Tag<Block> PASSABLE = new BlockTags.Wrapper(new ResourceLocation("crossroads", "beam_passable"));
    private static final VoxelShape[] COLLISION_MASK = new VoxelShape[3];

    public static boolean solidToBeams(BlockState state, World world, BlockPos pos, Direction toDir, int power) {
        VoxelShape mask;
        if (state.isAir((IBlockReader)world, pos) || PASSABLE.func_199685_a_((Object)state.func_177230_c())) {
            return false;
        }
        VoxelShape shape = state.func_196951_e((IBlockReader)world, pos);
        if (((Boolean)CRConfig.beamPowerCollision.get()).booleanValue()) {
            int radius = BeamUtil.getBeamRadius(power);
            switch (toDir.func_176740_k()) {
                case X: {
                    mask = Block.func_208617_a((double)0.0, (double)(8 - radius), (double)(8 - radius), (double)16.0, (double)(8 + radius), (double)(8 + radius));
                    break;
                }
                case Y: {
                    mask = Block.func_208617_a((double)(8 - radius), (double)0.0, (double)(8 - radius), (double)(8 + radius), (double)16.0, (double)(8 + radius));
                    break;
                }
                default: {
                    mask = Block.func_208617_a((double)(8 - radius), (double)(8 - radius), (double)0.0, (double)(8 + radius), (double)(8 + radius), (double)16.0);
                    break;
                }
            }
        } else {
            mask = COLLISION_MASK[toDir.func_176740_k().ordinal()];
        }
        return VoxelShapes.func_197879_c((VoxelShape)shape, (VoxelShape)mask, (IBooleanFunction)IBooleanFunction.field_223238_i_);
    }

    public static int getBeamRadius(int power) {
        if (power <= 0) {
            return 0;
        }
        return Math.min(8, (int)Math.round(Math.sqrt(power)));
    }

    static {
        BeamUtil.COLLISION_MASK[0] = Block.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
        BeamUtil.COLLISION_MASK[1] = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
        BeamUtil.COLLISION_MASK[2] = Block.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)16.0);
    }
}

