/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.beams;

import com.Da_Technomancer.crossroads.API.AdvancementTracker;
import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.effects.BeamEffect;
import com.Da_Technomancer.crossroads.API.effects.ChargeEffect;
import com.Da_Technomancer.crossroads.API.effects.EnchantEffect;
import com.Da_Technomancer.crossroads.API.effects.EnergizeEffect;
import com.Da_Technomancer.crossroads.API.effects.EqualibriumEffect;
import com.Da_Technomancer.crossroads.API.effects.ExplodeEffect;
import com.Da_Technomancer.crossroads.API.effects.GrowEffect;
import com.Da_Technomancer.crossroads.API.effects.LightEffect;
import com.Da_Technomancer.crossroads.API.effects.PlaceEffect;
import com.Da_Technomancer.crossroads.API.effects.RiftEffect;
import com.Da_Technomancer.crossroads.API.effects.TimeEffect;
import com.Da_Technomancer.crossroads.API.effects.VoidEffect;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;

public enum EnumBeamAlignments {
    TIME(new TimeEffect(), new Color(255, 100, 0), 16),
    ENCHANTMENT(new EnchantEffect(), new Color(251, 255, 184), 16),
    EQUILIBRIUM(new EqualibriumEffect(), new Color(255, 132, 255), 40),
    RIFT(new RiftEffect(), new Color(255, 0, 255), 96),
    CHARGE(new ChargeEffect(), new Color(255, 255, 0), 128),
    EXPANSION(new PlaceEffect(), new Color(0, 255, 255), 72),
    FUSION(BeamEffect.INSTANCE, new Color(132, 255, 255), 64),
    LIGHT(new LightEffect(), new Color(255, 255, 255), 128),
    STABILITY(new ExplodeEffect(), new Color(0, 0, 255), 254),
    POTENTIAL(new GrowEffect(), new Color(0, 255, 0), 254),
    ENERGY(new EnergizeEffect(), new Color(255, 0, 0), 254),
    VOID(new VoidEffect(), new Color(0, 0, 0), 0),
    NO_MATCH(BeamEffect.INSTANCE, new Color(255, 255, 255), 255);

    private final BeamEffect effect;
    private final Color mid;
    private final int range;

    private EnumBeamAlignments(BeamEffect eff, Color cent, int range) {
        this.effect = eff;
        this.mid = cent;
        this.range = range;
    }

    @Nonnull
    public BeamEffect getEffect() {
        return this.effect;
    }

    public boolean contains(Color test) {
        if (test == null) {
            return false;
        }
        return Math.abs(test.getRed() - this.mid.getRed()) < this.range && Math.abs(test.getGreen() - this.mid.getGreen()) < this.range && Math.abs(test.getBlue() - this.mid.getBlue()) < this.range;
    }

    @Nonnull
    public static EnumBeamAlignments getAlignment(@Nonnull BeamUnit magic) {
        return magic.isEmpty() ? NO_MATCH : EnumBeamAlignments.getAlignment(magic.getTrueRGB());
    }

    @Nonnull
    public static EnumBeamAlignments getAlignment(Color col) {
        for (EnumBeamAlignments elem : EnumBeamAlignments.values()) {
            if (!elem.contains(col)) continue;
            return elem;
        }
        return VOID;
    }

    public String getLocalName(boolean voi) {
        if (voi) {
            return MiscUtil.localize("alignment." + this.toString().toLowerCase() + ".void");
        }
        return MiscUtil.localize("alignment." + this.toString().toLowerCase());
    }

    public String toString() {
        return this.name().toLowerCase(Locale.US);
    }

    public boolean isDiscovered(PlayerEntity player) {
        return AdvancementTracker.hasAdvancement(player, "progress/alignment/" + this.toString());
    }

    public void discover(PlayerEntity player, boolean discover) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        AdvancementTracker.unlockAdvancement((ServerPlayerEntity)player, "progress/alignment/" + this.toString(), discover);
    }
}

