/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.effects;

import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.effects.BeamEffect;
import com.Da_Technomancer.crossroads.CRConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GrowEffect
extends BeamEffect {
    private static final Tag<Block> growBlacklist = new BlockTags.Wrapper(new ResourceLocation("crossroads", "growth_blacklist"));
    private static final DamageSource POTENTIAL_VOID = new DamageSource("potentialvoid").func_82726_p().func_76348_h();

    @Override
    public void doBeamEffect(EnumBeamAlignments align, boolean voi, int power, World worldIn, BlockPos pos, @Nullable Direction dir) {
        block13: {
            if (this.performTransmute(align, voi, power, worldIn, pos)) break block13;
            double range = Math.sqrt(power) / 2.0;
            if (voi) {
                BlockState state = worldIn.func_180495_p(pos);
                if (state.func_177230_c() instanceof IGrowable && state.func_177230_c() != Blocks.field_196555_aI) {
                    if (state.func_177230_c() == Blocks.field_196658_i) {
                        worldIn.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
                    } else {
                        worldIn.func_175656_a(pos, Blocks.field_196555_aI.func_176223_P());
                    }
                }
                List ents = worldIn.func_175647_a(LivingEntity.class, new AxisAlignedBB((double)pos.func_177958_n() - range, (double)pos.func_177956_o() - range, (double)pos.func_177952_p() - range, (double)pos.func_177958_n() + range + 1.0, (double)pos.func_177956_o() + range + 1.0, (double)pos.func_177952_p() + range + 1.0), EntityPredicates.field_94557_a);
                for (LivingEntity ent : ents) {
                    if (ent.func_70662_br()) {
                        ent.func_70691_i((float)power * 3.0f / 4.0f);
                        continue;
                    }
                    ent.func_70097_a(POTENTIAL_VOID, (float)power * 3.0f / 4.0f);
                }
            } else {
                List ents = worldIn.func_175647_a(LivingEntity.class, new AxisAlignedBB((double)pos.func_177958_n() - range, (double)pos.func_177956_o() - range, (double)pos.func_177952_p() - range, (double)pos.func_177958_n() + range, (double)pos.func_177956_o() + range, (double)pos.func_177952_p() + range), EntityPredicates.field_94557_a);
                for (LivingEntity ent : ents) {
                    if (ent.func_70662_br()) {
                        ent.func_70097_a(POTENTIAL_VOID, (float)power / 2.0f);
                        continue;
                    }
                    ent.func_70691_i((float)power / 2.0f);
                }
                int growMultiplier = (Integer)CRConfig.growMultiplier.get();
                if (growMultiplier > 1) {
                    power = power / growMultiplier + (worldIn.field_73012_v.nextInt(growMultiplier) < power % growMultiplier ? 1 : 0);
                }
                for (int i = 0; i < power; ++i) {
                    BlockState state = worldIn.func_180495_p(pos);
                    if (!(state.func_177230_c() instanceof IGrowable)) {
                        return;
                    }
                    if (growBlacklist.func_199685_a_((Object)state.func_177230_c())) {
                        return;
                    }
                    IGrowable growable = (IGrowable)state.func_177230_c();
                    if (!growable.func_176473_a((IBlockReader)worldIn, pos, state, false)) continue;
                    growable.func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, pos, state);
                }
            }
        }
    }
}

