/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.rotary;

import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.packets.SendMasterKeyToClient;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.blocks.rotary.LargeGearMaster;
import com.Da_Technomancer.crossroads.blocks.rotary.LargeGearSlave;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RotaryUtil {
    private static int masterKey = 1;
    private static final VoxelShape GEAR_ANCHOR_SHAPE = Block.func_208617_a((double)7.05, (double)7.05, (double)7.05, (double)8.95, (double)8.95, (double)8.95);

    public static void addRotaryInfo(List<ITextComponent> chat, double[] motData, double inertia, double rotRatio, boolean compact) {
        if (compact) {
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.rotary.compact", new Object[]{CRConfig.formatVal(motData[0]), CRConfig.formatVal(motData[1]), CRConfig.formatVal(motData[2]), CRConfig.formatVal(inertia), CRConfig.formatVal(rotRatio)}));
        } else {
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.rotary.speed", new Object[]{CRConfig.formatVal(motData[0])}));
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.rotary.energy", new Object[]{CRConfig.formatVal(motData[1])}));
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.rotary.power", new Object[]{CRConfig.formatVal(motData[2])}));
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.rotary.setup", new Object[]{CRConfig.formatVal(inertia), CRConfig.formatVal(rotRatio)}));
        }
    }

    public static double getDirSign(Direction oldGearFacing, Direction newGearFacing) {
        return -oldGearFacing.func_176743_c().func_179524_a() * newGearFacing.func_176743_c().func_179524_a();
    }

    public static double findEfficiency(double speedIn, double lowerLimit, double upperLimit) {
        return (speedIn = Math.abs(speedIn)) < lowerLimit ? 0.0 : (speedIn >= upperLimit ? 1.0 : (speedIn - lowerLimit) / (upperLimit - lowerLimit));
    }

    public static double getTotalEnergy(List<IAxleHandler> axles) {
        double sumEnergy = 0.0;
        double sumInertia = 0.0;
        double sumIW = 0.0;
        for (IAxleHandler axle : axles) {
            if (axle == null) continue;
            sumEnergy += axle.getMotionData()[1] * Math.signum(axle.getRotationRatio());
            sumInertia += axle.getMoInertia();
            sumIW += axle.getMoInertia() * Math.abs(axle.getMotionData()[0]);
        }
        if (sumInertia <= 0.0) {
            return 0.0;
        }
        sumEnergy = Math.signum(sumEnergy) * Math.max(0.0, Math.abs(sumEnergy) - (Double)CRConfig.rotaryLoss.get() * Math.pow(sumIW / sumInertia, 2.0));
        return sumEnergy;
    }

    public static boolean canConnectThrough(World world, BlockPos pos, Direction fromDir, Direction toDir) {
        BlockState state = world.func_180495_p(pos);
        return !state.func_215686_e((IBlockReader)world, pos) && state.func_177230_c() != CRBlocks.largeGearSlave && state.func_177230_c() != CRBlocks.largeGearMaster;
    }

    public static boolean solidToGears(World world, BlockPos pos, Direction side) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof LargeGearSlave || state.func_177230_c() instanceof LargeGearMaster && side != ((Direction)state.func_177229_b((IProperty)ESProperties.FACING)).func_176734_d()) {
            return false;
        }
        if (state.func_203425_a(BlockTags.field_206952_E)) {
            return false;
        }
        return !VoxelShapes.func_197879_c((VoxelShape)state.func_196952_d((IBlockReader)world, pos).func_212434_a(side), (VoxelShape)GEAR_ANCHOR_SHAPE, (IBooleanFunction)IBooleanFunction.field_223232_c_);
    }

    public static void increaseMasterKey(boolean sendPacket) {
        ++masterKey;
        if (sendPacket) {
            CRPackets.sendPacketToAll(new SendMasterKeyToClient(masterKey));
        }
    }

    public static int getMasterKey() {
        return masterKey;
    }

    public static void setMasterKey(int masterKey) {
        RotaryUtil.masterKey = masterKey;
    }
}

