/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.technomancy;

import com.Da_Technomancer.crossroads.API.alchemy.AlchemyUtil;
import com.Da_Technomancer.crossroads.API.alchemy.EnumReagents;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.technomancy.IFluxLink;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.essentials.tileentities.ILinkTE;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class FluxUtil {
    public static final int FLUX_TIME = 4;
    public static final int[] COLOR_CODES = new int[]{new Color(0, 0, 0).getRGB(), new Color(42, 0, 51).getRGB(), new Color(212, 192, 220).getRGB()};

    public static int findReadingFlux(IFluxLink te, int flux, int fluxToTrans) {
        return Math.max(flux, fluxToTrans);
    }

    public static int performTransfer(IFluxLink src, Set<BlockPos> links, int toTransfer) {
        if (toTransfer <= 0) {
            return 0;
        }
        World world = src.getTE().func_145831_w();
        BlockPos pos = src.getTE().func_174877_v();
        Object[] dests = links.stream().map(linkPos -> world.func_175625_s(pos.func_177971_a((Vec3i)linkPos))).filter(te -> te instanceof IFluxLink && ((IFluxLink)te).allowAccepting()).toArray();
        if (dests.length == 0) {
            return toTransfer;
        }
        int toTransPer = toTransfer / dests.length;
        for (Object dest : dests) {
            IFluxLink linked = (IFluxLink)dest;
            linked.addFlux(toTransPer);
            src.addFlux(-toTransPer);
            FluxUtil.renderFlux(world, pos, linked.getTE().func_174877_v(), toTransPer);
        }
        return toTransfer - toTransPer * dests.length;
    }

    public static void renderFlux(World world, BlockPos src, BlockPos dest, int qty) {
        if (qty > 0) {
            CRRenderUtil.addArc(world, (float)src.func_177958_n() + 0.5f, (float)src.func_177956_o() + 0.5f, (float)src.func_177952_p() + 0.5f, (float)dest.func_177958_n() + 0.5f, (float)dest.func_177956_o() + 0.5f, (float)dest.func_177952_p() + 0.5f, 3, 0.0f, COLOR_CODES[(int)(world.func_82737_E() % 3L)]);
        }
    }

    public static void addFluxInfo(List<ITextComponent> tooltip, IFluxLink te, int fluxPerCycle) {
        if (fluxPerCycle < 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.flux_simple", new Object[]{te.getReadingFlux(), te.getMaxFlux(), CRConfig.formatVal(100.0f * (float)te.getReadingFlux() / (float)te.getMaxFlux())}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.flux", new Object[]{te.getReadingFlux(), te.getMaxFlux(), CRConfig.formatVal(100.0f * (float)te.getReadingFlux() / (float)te.getMaxFlux()), CRConfig.formatVal((float)fluxPerCycle / 4.0f)}));
        }
    }

    public static void addLinkInfo(List<ITextComponent> tooltip, ILinkTE te) {
        Set links = te.getLinks();
        if (links.size() == 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.link.none", new Object[0]));
        } else {
            BlockPos tePos = te.getTE().func_174877_v();
            int totalLinked = links.size();
            if (totalLinked <= 4) {
                for (BlockPos relPos : links) {
                    BlockPos linkPos = tePos.func_177971_a((Vec3i)relPos);
                    tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.link", new Object[]{linkPos.func_177958_n(), linkPos.func_177956_o(), linkPos.func_177952_p()}));
                }
            } else {
                int printed = 0;
                for (BlockPos relPos : links) {
                    BlockPos linkPos = tePos.func_177971_a((Vec3i)relPos);
                    tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.link", new Object[]{linkPos.func_177958_n(), linkPos.func_177956_o(), linkPos.func_177952_p()}));
                    if (++printed != 4) continue;
                    break;
                }
                tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.link.excess", new Object[]{totalLinked + 1 - printed}));
            }
        }
    }

    public static boolean checkFluxOverload(IFluxLink te) {
        if (te.getFlux() > te.getMaxFlux()) {
            World world = te.getTE().func_145831_w();
            BlockPos pos = te.getTE().func_174877_v();
            world.func_175655_b(pos, ((Boolean)CRConfig.entropyDropBlock.get()).booleanValue());
            FluxUtil.fluxEvent(world, pos);
            return true;
        }
        return false;
    }

    public static ActionResultType handleFluxLinking(World world, BlockPos pos, ItemStack stack, PlayerEntity player) {
        if (ILinkTE.isLinkTool((ItemStack)stack)) {
            TileEntity te = world.func_175625_s(pos);
            if (!world.field_72995_K && te instanceof ILinkTE) {
                ((ILinkTE)te).wrench(stack, player);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static void fluxEvent(World worldIn, BlockPos pos) {
        if (((Boolean)CRConfig.fluxEvent.get()).booleanValue()) {
            int selector = (int)(Math.random() * 100.0);
            if (selector < 50) {
                worldIn.func_217385_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, (Boolean)CRConfig.entropyDropBlock.get() != false ? Explosion.Mode.BREAK : Explosion.Mode.DESTROY);
            } else if (selector < 65) {
                ReagentMap map = new ReagentMap();
                map.addReagent(EnumReagents.PHELOSTOGEN.id(), 32, 100.0);
                map.addReagent(EnumReagents.ALCHEMICAL_SALT.id(), 10, 100.0);
                map.addReagent(EnumReagents.ELEM_CHARGE.id(), 10, 100.0);
                AlchemyUtil.releaseChemical(worldIn, pos, map);
            } else if (selector < 72) {
                ReagentMap map = new ReagentMap();
                map.addReagent(EnumReagents.PHELOSTOGEN.id(), 32, 100.0);
                map.addReagent(EnumReagents.ALCHEMICAL_SALT.id(), 10, 100.0);
                map.addReagent(EnumReagents.AETHER.id(), 10, 100.0);
                AlchemyUtil.releaseChemical(worldIn, pos, map);
            } else if (selector < 75) {
                ReagentMap map = new ReagentMap();
                map.addReagent(EnumReagents.PHELOSTOGEN.id(), 32, 100.0);
                AlchemyUtil.releaseChemical(worldIn, pos, map);
            } else {
                EnumBeamAlignments.POTENTIAL.getEffect().doBeamEffect(EnumBeamAlignments.POTENTIAL, true, 64, worldIn, pos, null);
            }
        } else {
            worldIn.func_217385_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 4.0f, Explosion.Mode.BREAK);
        }
    }
}

