/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.templates;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.beams.BeamManager;
import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.beams.BeamUnitStorage;
import com.Da_Technomancer.crossroads.API.beams.IBeamHandler;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.packets.IIntReceiver;
import com.Da_Technomancer.crossroads.API.packets.SendIntToClient;
import com.Da_Technomancer.crossroads.API.templates.IBeamRenderTE;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class BeamRenderTE
extends TileEntity
implements IBeamRenderTE,
ITickableTileEntity,
IIntReceiver {
    protected int[] beamPackets = new int[6];
    protected BeamManager[] beamer;
    protected BeamUnitStorage[] queued = new BeamUnitStorage[]{new BeamUnitStorage(), new BeamUnitStorage()};
    protected long activeCycle;
    protected BeamUnit[] prevMag = new BeamUnit[]{BeamUnit.EMPTY, BeamUnit.EMPTY, BeamUnit.EMPTY, BeamUnit.EMPTY, BeamUnit.EMPTY, BeamUnit.EMPTY};
    protected LazyOptional<IBeamHandler> lazyOptional = LazyOptional.of(() -> new BeamHandler());

    public BeamRenderTE(TileEntityType<?> type) {
        super(type);
    }

    protected abstract boolean[] inputSides();

    protected abstract boolean[] outputSides();

    protected int getLimit() {
        return 64000;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-16, -16, -16), this.field_174879_c.func_177982_a(17, 17, 17));
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.beamer = null;
        this.beamPackets = new int[6];
        for (int i = 0; i < 6; ++i) {
            this.prevMag[i] = BeamUnit.EMPTY;
            this.refreshBeam(i);
        }
        this.lazyOptional.invalidate();
        this.lazyOptional = LazyOptional.of(() -> new BeamHandler());
    }

    protected void refreshBeam(int index) {
        int packet;
        this.beamPackets[index] = packet = this.beamer == null || this.beamer[index] == null ? 0 : this.beamer[index].genPacket();
        if (!this.field_145850_b.field_72995_K) {
            CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, new SendIntToClient((byte)index, packet, this.field_174879_c));
        }
        if (this.beamer != null && this.beamer[index] != null && !this.beamer[index].getLastSent().isEmpty()) {
            this.prevMag[index] = this.beamer[index].getLastSent();
        }
    }

    @Override
    public int[] getRenderedBeams() {
        return this.beamPackets;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 4L == 0L) {
            if (this.beamer == null) {
                this.beamer = new BeamManager[6];
                boolean[] outputs = this.outputSides();
                for (int i = 0; i < 6; ++i) {
                    if (!outputs[i]) continue;
                    this.beamer[i] = new BeamManager(Direction.func_82600_a((int)i), this.field_174879_c);
                }
            }
            BeamUnit out = this.shiftStorage();
            this.activeCycle = this.field_145850_b.func_82737_E();
            if (out.getPower() > this.getLimit()) {
                out = out.mult((float)this.getLimit() / (float)out.getPower(), true);
            }
            this.doEmit(out);
        }
    }

    @Nonnull
    protected BeamUnit shiftStorage() {
        BeamUnit out = this.queued[0].getOutput();
        this.queued[0].clear();
        this.queued[0].addBeam(this.queued[1]);
        this.queued[1].clear();
        this.func_70296_d();
        return out;
    }

    protected abstract void doEmit(@Nonnull BeamUnit var1);

    @Override
    public void receiveInt(byte identifier, int message, ServerPlayerEntity player) {
        if (identifier < 6 && identifier >= 0) {
            this.beamPackets[identifier] = message;
        }
    }

    @Override
    public BeamUnit[] getLastSent() {
        return this.prevMag;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        for (int i = 0; i < 6; ++i) {
            if (this.beamPackets[i] == 0) continue;
            nbt.func_74768_a(i + "_beam_packet", this.beamPackets[i]);
        }
        return nbt;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.queued[0].writeToNBT("queue0", nbt);
        this.queued[1].writeToNBT("queue1", nbt);
        nbt.func_74772_a("cyc", this.activeCycle);
        if (this.beamer != null) {
            for (int i = 0; i < 6; ++i) {
                nbt.func_74768_a(i + "_beam_packet", this.beamPackets[i]);
            }
        }
        return nbt;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.queued[0] = BeamUnitStorage.readFromNBT("queue0", nbt);
        this.queued[1] = BeamUnitStorage.readFromNBT("queue1", nbt);
        this.activeCycle = nbt.func_74763_f("cyc");
        for (int i = 0; i < 6; ++i) {
            this.beamPackets[i] = nbt.func_74762_e(i + "_beam_packet");
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.lazyOptional.invalidate();
        if (this.beamer != null && this.field_145850_b != null) {
            for (BeamManager manager : this.beamer) {
                if (manager == null) continue;
                manager.emit(BeamUnit.EMPTY, this.field_145850_b);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction dir) {
        if (cap == Capabilities.BEAM_CAPABILITY && (dir == null || this.inputSides()[dir.func_176745_a()])) {
            return this.lazyOptional;
        }
        return super.getCapability(cap, dir);
    }

    protected class BeamHandler
    implements IBeamHandler {
        protected BeamHandler() {
        }

        @Override
        public void setBeam(@Nonnull BeamUnit mag) {
            if (!mag.isEmpty()) {
                BeamRenderTE.this.queued[BeamRenderTE.this.field_145850_b.func_82737_E() == BeamRenderTE.this.activeCycle ? 0 : 1].addBeam(mag);
                BeamRenderTE.this.func_70296_d();
            }
        }
    }
}

