/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.API.templates;

import com.Da_Technomancer.crossroads.Crossroads;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public abstract class TileEntityContainer<U extends TileEntity>
extends Container {
    protected final IInventory playerInv;
    protected final U te;

    public TileEntityContainer(ContainerType<? extends Container> type, int windowId, PlayerInventory playerInv, PacketBuffer data) {
        super(type, windowId);
        this.playerInv = playerInv;
        BlockPos pos = data.func_179259_c();
        TileEntity rawTE = playerInv.field_70458_d.field_70170_p.func_175625_s(pos);
        Object worldTe = null;
        if (rawTE != null) {
            try {
                worldTe = rawTE;
            }
            catch (ClassCastException e) {
                Crossroads.logger.error("UI opened without TE in world!");
            }
        } else {
            Crossroads.logger.error("Null TileEntity passed to TileEntityContainer!");
        }
        if (worldTe == null) {
            worldTe = this.generateEmptyTE();
            worldTe.func_226984_a_(playerInv.field_70458_d.field_70170_p, pos);
            Crossroads.logger.error("Null world tile entity! Generating dummy TE. Report to mod author; type=%1$s", (Object)type.toString());
        }
        this.te = worldTe;
        this.addSlots();
        int[] invStart = this.getInvStart();
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInv, x, invStart[0] + x * 18, invStart[1] + 58));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInv, x + y * 9 + 9, invStart[0] + x * 18, invStart[1] + y * 18));
            }
        }
    }

    protected U generateEmptyTE() {
        TileEntity created;
        try {
            Class clazz = (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            created = (TileEntity)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new NullPointerException("Could not instantiate fake TileEntity for TileEntityContainer! Report to mod author!");
        }
        return (U)created;
    }

    protected abstract void addSlots();

    protected abstract int slotCount();

    protected int[] getInvStart() {
        return new int[]{8, 84};
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int fromSlot) {
        ItemStack previous = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(fromSlot);
        if (slot != null && slot.func_75216_d()) {
            ItemStack current = slot.func_75211_c();
            previous = current.func_77946_l();
            if (fromSlot < this.slotCount() ? !this.func_75135_a(current, this.slotCount(), 36 + this.slotCount(), true) : !this.func_75135_a(current, 0, this.slotCount(), false)) {
                return ItemStack.field_190927_a;
            }
            if (current.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (current.func_190916_E() == previous.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, current);
        }
        return previous;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return ((IInventory)this.te).func_70300_a(playerIn);
    }

    protected static class OutputSlot
    extends Slot {
        public OutputSlot(IInventory te, int index, int x, int y) {
            super(te, index, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }
    }

    protected static class StrictSlot
    extends Slot {
        public StrictSlot(IInventory te, int index, int x, int y) {
            super(te, index, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            return this.field_75224_c.func_94041_b(this.getSlotIndex(), stack);
        }
    }
}

