/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.EventHandlerClient;
import com.Da_Technomancer.crossroads.EventHandlerCommon;
import com.Da_Technomancer.crossroads.EventHandlerServer;
import com.Da_Technomancer.crossroads.Keys;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.entity.CREntities;
import com.Da_Technomancer.crossroads.entity.EntityBullet;
import com.Da_Technomancer.crossroads.entity.EntityFlameCore;
import com.Da_Technomancer.crossroads.entity.EntityFlyingMachine;
import com.Da_Technomancer.crossroads.entity.EntityGhostMarker;
import com.Da_Technomancer.crossroads.entity.EntityNitro;
import com.Da_Technomancer.crossroads.entity.EntityShell;
import com.Da_Technomancer.crossroads.fluids.CRFluids;
import com.Da_Technomancer.crossroads.gui.BeamExtractorScreen;
import com.Da_Technomancer.crossroads.gui.BlastFurnaceScreen;
import com.Da_Technomancer.crossroads.gui.ColorChartScreen;
import com.Da_Technomancer.crossroads.gui.CopshowiumMakerScreen;
import com.Da_Technomancer.crossroads.gui.CrucibleScreen;
import com.Da_Technomancer.crossroads.gui.DetailedCrafterScreen;
import com.Da_Technomancer.crossroads.gui.FatCollectorScreen;
import com.Da_Technomancer.crossroads.gui.FatCongealerScreen;
import com.Da_Technomancer.crossroads.gui.FatFeederScreen;
import com.Da_Technomancer.crossroads.gui.FireboxScreen;
import com.Da_Technomancer.crossroads.gui.FluidCoolerScreen;
import com.Da_Technomancer.crossroads.gui.FluidTankScreen;
import com.Da_Technomancer.crossroads.gui.HeatLimiterScreen;
import com.Da_Technomancer.crossroads.gui.IceboxScreen;
import com.Da_Technomancer.crossroads.gui.MillstoneScreen;
import com.Da_Technomancer.crossroads.gui.OreCleanserScreen;
import com.Da_Technomancer.crossroads.gui.RadiatorScreen;
import com.Da_Technomancer.crossroads.gui.ReagentFilterScreen;
import com.Da_Technomancer.crossroads.gui.RotaryPumpScreen;
import com.Da_Technomancer.crossroads.gui.SaltReactorScreen;
import com.Da_Technomancer.crossroads.gui.SmelterScreen;
import com.Da_Technomancer.crossroads.gui.StampMillScreen;
import com.Da_Technomancer.crossroads.gui.SteamBoilerScreen;
import com.Da_Technomancer.crossroads.gui.SteamerScreen;
import com.Da_Technomancer.crossroads.gui.WaterCentrifugeScreen;
import com.Da_Technomancer.crossroads.gui.WindingTableScreen;
import com.Da_Technomancer.crossroads.gui.container.BeamExtractorContainer;
import com.Da_Technomancer.crossroads.gui.container.BlastFurnaceContainer;
import com.Da_Technomancer.crossroads.gui.container.ColorChartContainer;
import com.Da_Technomancer.crossroads.gui.container.CopshowiumMakerContainer;
import com.Da_Technomancer.crossroads.gui.container.CrucibleContainer;
import com.Da_Technomancer.crossroads.gui.container.DetailedCrafterContainer;
import com.Da_Technomancer.crossroads.gui.container.FatCollectorContainer;
import com.Da_Technomancer.crossroads.gui.container.FatCongealerContainer;
import com.Da_Technomancer.crossroads.gui.container.FatFeederContainer;
import com.Da_Technomancer.crossroads.gui.container.FireboxContainer;
import com.Da_Technomancer.crossroads.gui.container.FluidCoolerContainer;
import com.Da_Technomancer.crossroads.gui.container.FluidTankContainer;
import com.Da_Technomancer.crossroads.gui.container.HeatLimiterContainer;
import com.Da_Technomancer.crossroads.gui.container.IceboxContainer;
import com.Da_Technomancer.crossroads.gui.container.MillstoneContainer;
import com.Da_Technomancer.crossroads.gui.container.OreCleanserContainer;
import com.Da_Technomancer.crossroads.gui.container.RadiatorContainer;
import com.Da_Technomancer.crossroads.gui.container.ReagentFilterContainer;
import com.Da_Technomancer.crossroads.gui.container.RotaryPumpContainer;
import com.Da_Technomancer.crossroads.gui.container.SaltReactorContainer;
import com.Da_Technomancer.crossroads.gui.container.SmelterContainer;
import com.Da_Technomancer.crossroads.gui.container.StampMillContainer;
import com.Da_Technomancer.crossroads.gui.container.SteamBoilerContainer;
import com.Da_Technomancer.crossroads.gui.container.SteamerContainer;
import com.Da_Technomancer.crossroads.gui.container.WaterCentrifugeContainer;
import com.Da_Technomancer.crossroads.gui.container.WindingTableContainer;
import com.Da_Technomancer.crossroads.integration.curios.CurioHelper;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.crafting.recipes.AlchemyRec;
import com.Da_Technomancer.crossroads.items.crafting.recipes.BeamExtractRec;
import com.Da_Technomancer.crossroads.items.crafting.recipes.BeamTransmuteRec;
import com.Da_Technomancer.crossroads.items.crafting.recipes.BlastFurnaceRec;
import com.Da_Technomancer.crossroads.items.crafting.recipes.BoboRec;
import com.Da_Technomancer.crossroads.items.crafting.recipes.CentrifugeRec;
import com.Da_Technomancer.crossroads.items.crafting.recipes.CopshowiumRec;
import com.Da_Technomancer.crossroads.items.crafting.recipes.CrucibleRec;
import com.Da_Technomancer.crossroads.items.crafting.recipes.DetailedCrafterRec;
import com.Da_Technomancer.crossroads.items.crafting.recipes.FluidCoolingRec;
import com.Da_Technomancer.crossroads.items.crafting.recipes.IceboxRec;
import com.Da_Technomancer.crossroads.items.crafting.recipes.MillRec;
import com.Da_Technomancer.crossroads.items.crafting.recipes.OreCleanserRec;
import com.Da_Technomancer.crossroads.items.crafting.recipes.SingleIngrRecipe;
import com.Da_Technomancer.crossroads.items.crafting.recipes.StampMillRec;
import com.Da_Technomancer.crossroads.items.itemSets.ItemSets;
import com.Da_Technomancer.crossroads.particles.CRParticles;
import com.Da_Technomancer.crossroads.particles.ColorParticleType;
import com.Da_Technomancer.crossroads.render.CRRenderTypes;
import com.Da_Technomancer.crossroads.render.TESR.CRRendererRegistry;
import com.Da_Technomancer.crossroads.tileentities.CRTileEntity;
import com.Da_Technomancer.crossroads.world.ModWorldGen;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="crossroads")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Crossroads {
    public static final String MODID = "crossroads";
    public static final String MODNAME = "Crossroads";
    public static final Logger logger = LogManager.getLogger((String)"Crossroads");

    public Crossroads() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonInit);
        bus.addListener(this::clientInit);
        CRConfig.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        CRConfig.load();
    }

    private void commonInit(FMLCommonSetupEvent e) {
        CRPackets.preInit();
        Capabilities.register();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerCommon());
        CurioHelper.initIntegration();
    }

    private void clientInit(FMLClientSetupEvent e) {
        CRBlocks.clientInit();
        CRItems.clientInit();
        CRRendererRegistry.registerBlockRenderer();
        Keys.init();
        CREntities.clientInit();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClient());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        IForgeRegistry registry = e.getRegistry();
        CRBlocks.init();
        ItemSets.init();
        CRFluids.init();
        for (Block block : CRBlocks.toRegister) {
            registry.register((IForgeRegistryEntry)block);
        }
        CRBlocks.toRegister.clear();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> e) {
        IForgeRegistry registry = e.getRegistry();
        CRItems.init();
        for (Item item : CRItems.toRegister) {
            registry.register((IForgeRegistryEntry)item);
        }
        CRItems.toRegister.clear();
    }

    @SubscribeEvent
    public static void registerFluids(RegistryEvent.Register<Fluid> e) {
        IForgeRegistry registry = e.getRegistry();
        for (Fluid f : CRFluids.toRegister) {
            registry.register((IForgeRegistryEntry)f);
        }
        CRFluids.toRegister.clear();
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> e) {
        IForgeRegistry reg = e.getRegistry();
        reg.register((IForgeRegistryEntry)((IRecipeSerializer)new SingleIngrRecipe.SingleRecipeSerializer<StampMillRec>(StampMillRec::new).setRegistryName("stamp_mill")));
        reg.register((IForgeRegistryEntry)((IRecipeSerializer)new MillRec.Serializer().setRegistryName("mill")));
        reg.register((IForgeRegistryEntry)((IRecipeSerializer)new SingleIngrRecipe.SingleRecipeSerializer<OreCleanserRec>(OreCleanserRec::new).setRegistryName("ore_cleanser")));
        reg.register((IForgeRegistryEntry)((IRecipeSerializer)new BeamExtractRec.Serializer().setRegistryName("beam_extract")));
        reg.register((IForgeRegistryEntry)((IRecipeSerializer)new IceboxRec.Serializer().setRegistryName("cooling")));
        reg.register((IForgeRegistryEntry)((IRecipeSerializer)new CentrifugeRec.Serializer().setRegistryName("centrifuge")));
        reg.register((IForgeRegistryEntry)((IRecipeSerializer)new AlchemyRec.Serializer().setRegistryName("alchemy")));
        reg.register((IForgeRegistryEntry)((IRecipeSerializer)new BlastFurnaceRec.Serializer().setRegistryName("cr_blast_furnace")));
        reg.register((IForgeRegistryEntry)((IRecipeSerializer)new FluidCoolingRec.Serializer().setRegistryName("fluid_cooling")));
        reg.register((IForgeRegistryEntry)((IRecipeSerializer)new CrucibleRec.Serializer().setRegistryName("crucible")));
        reg.register((IForgeRegistryEntry)((IRecipeSerializer)new DetailedCrafterRec.Serializer().setRegistryName("detailed_crafter")));
        reg.register((IForgeRegistryEntry)((IRecipeSerializer)new BeamTransmuteRec.Serializer().setRegistryName("beam_transmute")));
        reg.register((IForgeRegistryEntry)((IRecipeSerializer)new BoboRec.Serializer().setRegistryName("bobo")));
        reg.register((IForgeRegistryEntry)((IRecipeSerializer)new CopshowiumRec.Serializer().setRegistryName("copshowium")));
    }

    @SubscribeEvent
    public static void registerEnts(RegistryEvent.Register<EntityType<?>> e) {
        IForgeRegistry reg = e.getRegistry();
        reg.register((IForgeRegistryEntry)((EntityType)EntityType.Builder.func_220322_a(EntityFlameCore::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_200705_b().setShouldReceiveVelocityUpdates(false).func_220321_a(1.0f, 1.0f).func_206830_a("flame_core").setRegistryName("flame_core")));
        reg.register((IForgeRegistryEntry)((EntityType)EntityType.Builder.func_220322_a(EntityBullet::new, (EntityClassification)EntityClassification.MISC).func_220320_c().setTrackingRange(64).setUpdateInterval(5).func_220321_a(0.25f, 0.25f).func_206830_a("cr_bullet").setRegistryName("cr_bullet")));
        reg.register((IForgeRegistryEntry)((EntityType)EntityType.Builder.func_220322_a(EntityShell::new, (EntityClassification)EntityClassification.MISC).func_220320_c().setTrackingRange(64).setUpdateInterval(5).func_220321_a(0.25f, 0.25f).func_206830_a("shell").setRegistryName("shell")));
        reg.register((IForgeRegistryEntry)((EntityType)EntityType.Builder.func_220322_a(EntityNitro::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(64).setUpdateInterval(5).func_206830_a("nitro").setRegistryName("nitro")));
        reg.register((IForgeRegistryEntry)((EntityType)EntityType.Builder.func_220322_a(EntityGhostMarker::new, (EntityClassification)EntityClassification.MISC).func_200705_b().setTrackingRange(64).setUpdateInterval(20).func_220320_c().setShouldReceiveVelocityUpdates(false).func_206830_a("ghost_marker").setRegistryName("ghost_marker")));
        reg.register((IForgeRegistryEntry)((EntityType)EntityType.Builder.func_220322_a(EntityFlyingMachine::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 1.3f).setTrackingRange(64).setUpdateInterval(1).func_206830_a("flying_machine").setRegistryName("flying_machine")));
    }

    @SubscribeEvent
    public static void registerParticles(RegistryEvent.Register<ParticleType<?>> e) {
        IForgeRegistry registry = e.getRegistry();
        registry.register((IForgeRegistryEntry)new ColorParticleType("color_flame", false));
        registry.register((IForgeRegistryEntry)new ColorParticleType("color_gas", false));
        registry.register((IForgeRegistryEntry)new ColorParticleType("color_liquid", false));
        registry.register((IForgeRegistryEntry)new ColorParticleType("color_solid", false));
        registry.register((IForgeRegistryEntry)new ColorParticleType("color_splash", false));
    }

    @SubscribeEvent
    public static void registerParticleFactories(ParticleFactoryRegisterEvent e) {
        CRParticles.clientInit();
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> e) {
        IForgeRegistry reg = e.getRegistry();
        CRTileEntity.init(reg);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> e) {
        Crossroads.registerCon(FireboxContainer::new, FireboxScreen::new, "firebox", e);
        Crossroads.registerCon(IceboxContainer::new, IceboxScreen::new, "icebox", e);
        Crossroads.registerCon(FluidCoolerContainer::new, FluidCoolerScreen::new, "fluid_cooler", e);
        Crossroads.registerCon(CrucibleContainer::new, CrucibleScreen::new, "crucible", e);
        Crossroads.registerCon(SaltReactorContainer::new, SaltReactorScreen::new, "salt_reactor", e);
        Crossroads.registerCon(SmelterContainer::new, SmelterScreen::new, "smelter", e);
        Crossroads.registerCon(BlastFurnaceContainer::new, BlastFurnaceScreen::new, "ind_blast_furnace", e);
        Crossroads.registerCon(MillstoneContainer::new, MillstoneScreen::new, "millstone", e);
        Crossroads.registerCon(StampMillContainer::new, StampMillScreen::new, "stamp_mill", e);
        Crossroads.registerCon(FatCollectorContainer::new, FatCollectorScreen::new, "fat_collector", e);
        Crossroads.registerCon(FatCongealerContainer::new, FatCongealerScreen::new, "fat_congealer", e);
        Crossroads.registerCon(FatFeederContainer::new, FatFeederScreen::new, "fat_feeder", e);
        Crossroads.registerCon(FluidTankContainer::new, FluidTankScreen::new, "fluid_tank", e);
        Crossroads.registerCon(OreCleanserContainer::new, OreCleanserScreen::new, "ore_cleanser", e);
        Crossroads.registerCon(RadiatorContainer::new, RadiatorScreen::new, "radiator", e);
        Crossroads.registerCon(SteamBoilerContainer::new, SteamBoilerScreen::new, "steam_boiler", e);
        Crossroads.registerCon(WaterCentrifugeContainer::new, WaterCentrifugeScreen::new, "water_centrifuge", e);
        Crossroads.registerCon(ColorChartContainer::new, ColorChartScreen::new, "color_chart", e);
        Crossroads.registerCon(BeamExtractorContainer::new, BeamExtractorScreen::new, "beam_extractor", e);
        Crossroads.registerCon(HeatLimiterContainer::new, HeatLimiterScreen::new, "heat_limiter", e);
        Crossroads.registerCon(RotaryPumpContainer::new, RotaryPumpScreen::new, "rotary_pump", e);
        Crossroads.registerCon(DetailedCrafterContainer::new, DetailedCrafterScreen::new, "detailed_crafter", e);
        Crossroads.registerCon(ReagentFilterContainer::new, ReagentFilterScreen::new, "reagent_filter", e);
        Crossroads.registerCon(CopshowiumMakerContainer::new, CopshowiumMakerScreen::new, "copshowium_maker", e);
        Crossroads.registerCon(SteamerContainer::new, SteamerScreen::new, "steamer", e);
        Crossroads.registerCon(WindingTableContainer::new, WindingTableScreen::new, "winding_table", e);
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @SubscribeEvent
    public static void registerContainerTypes(RegistryEvent.Register<ContainerType<?>> e) {
        Crossroads.registerConType(FireboxContainer::new, "firebox", e);
        Crossroads.registerConType(IceboxContainer::new, "icebox", e);
        Crossroads.registerConType(FluidCoolerContainer::new, "fluid_cooler", e);
        Crossroads.registerConType(CrucibleContainer::new, "crucible", e);
        Crossroads.registerConType(SaltReactorContainer::new, "salt_reactor", e);
        Crossroads.registerConType(SmelterContainer::new, "smelter", e);
        Crossroads.registerConType(BlastFurnaceContainer::new, "ind_blast_furnace", e);
        Crossroads.registerConType(MillstoneContainer::new, "millstone", e);
        Crossroads.registerConType(StampMillContainer::new, "stamp_mill", e);
        Crossroads.registerConType(FatCollectorContainer::new, "fat_collector", e);
        Crossroads.registerConType(FatCongealerContainer::new, "fat_congealer", e);
        Crossroads.registerConType(FatFeederContainer::new, "fat_feeder", e);
        Crossroads.registerConType(FluidTankContainer::new, "fluid_tank", e);
        Crossroads.registerConType(OreCleanserContainer::new, "ore_cleanser", e);
        Crossroads.registerConType(RadiatorContainer::new, "radiator", e);
        Crossroads.registerConType(SteamBoilerContainer::new, "steam_boiler", e);
        Crossroads.registerConType(WaterCentrifugeContainer::new, "water_centrifuge", e);
        Crossroads.registerConType(ColorChartContainer::new, "color_chart", e);
        Crossroads.registerConType(BeamExtractorContainer::new, "beam_extractor", e);
        Crossroads.registerConType(HeatLimiterContainer::new, "heat_limiter", e);
        Crossroads.registerConType(RotaryPumpContainer::new, "rotary_pump", e);
        Crossroads.registerConType(DetailedCrafterContainer::new, "detailed_crafter", e);
        Crossroads.registerConType(ReagentFilterContainer::new, "reagent_filter", e);
        Crossroads.registerConType(CopshowiumMakerContainer::new, "copshowium_maker", e);
        Crossroads.registerConType(SteamerContainer::new, "steamer", e);
        Crossroads.registerConType(WindingTableContainer::new, "winding_table", e);
    }

    private static <T extends Container> ContainerType<T> registerConType(IContainerFactory<T> cons, String id, RegistryEvent.Register<ContainerType<?>> reg) {
        ContainerType contType = new ContainerType(cons);
        contType.setRegistryName(new ResourceLocation(MODID, id));
        reg.getRegistry().register((IForgeRegistryEntry)contType);
        return contType;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static <T extends Container> void registerCon(IContainerFactory<T> cons, ScreenManager.IScreenFactory<T, ContainerScreen<T>> screenFactory, String id, RegistryEvent.Register<ContainerType<?>> reg) {
        ContainerType<T> contType = Crossroads.registerConType(cons, id, reg);
        ScreenManager.func_216911_a(contType, screenFactory);
    }

    @SubscribeEvent
    public static void registerWorldgen(RegistryEvent.Register<Feature<?>> e) {
        ModWorldGen.register(e.getRegistry());
    }

    @SubscribeEvent
    public static void serverStarted(FMLServerStartedEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerServer());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        CRRenderTypes.stitchTextures(event);
    }
}

