/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.SpreadableSnowyDirtBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class BlockSalt
extends FallingBlock {
    private static final DamageSource SALT_DAMAGE = new DamageSource("salt");
    private static final HashMap<Block, Block> coralMap = new HashMap(20);

    protected BlockSalt() {
        super(Block.Properties.func_200945_a((Material)Material.field_151595_p).harvestTool(ToolType.SHOVEL).harvestLevel(0).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h).func_200944_c());
        String name = "block_salt";
        this.setRegistryName(name);
        CRBlocks.toRegister.add((Block)this);
        CRBlocks.blockAddQue(this);
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.field_72995_K && (entityIn instanceof SlimeEntity || entityIn instanceof CreeperEntity)) {
            entityIn.func_70097_a(SALT_DAMAGE, 20.0f);
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public static void salinate(World worldIn, BlockPos pos) {
        BlockState killState = worldIn.func_180495_p(pos);
        if (killState.func_177230_c() == Blocks.field_150346_d) {
            worldIn.func_175656_a(pos, Blocks.field_196660_k.func_176223_P());
        } else if (killState.func_177230_c() instanceof SpreadableSnowyDirtBlock) {
            worldIn.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        } else if (killState.func_177230_c() instanceof BushBlock) {
            worldIn.func_175656_a(pos, Blocks.field_196555_aI.func_176223_P());
        } else if (killState.func_177230_c() == Blocks.field_150458_ak) {
            worldIn.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        } else if (coralMap.containsKey(killState.func_177230_c())) {
            worldIn.func_175656_a(pos, coralMap.get(killState.func_177230_c()).func_176223_P());
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (worldIn.field_72995_K) {
            return;
        }
        super.func_225534_a_(state, worldIn, pos, rand);
        for (int i = 0; i < 10; ++i) {
            BlockPos killPos = pos.func_177982_a(rand.nextInt(5) - 2, rand.nextInt(3) - 1, rand.nextInt(5) - 2);
            BlockSalt.salinate((World)worldIn, killPos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_189876_x(BlockState state) {
        return Color.WHITE.getRGB();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.salt_block", new Object[0]));
        tooltip.add(new TranslationTextComponent("tt.crossroads.salt_block.quip", new Object[0]).func_150255_a(MiscUtil.TT_QUIP));
    }

    static {
        coralMap.put(Blocks.field_203963_jE, Blocks.field_204404_jE);
        coralMap.put(Blocks.field_203964_jF, Blocks.field_204405_jF);
        coralMap.put(Blocks.field_203965_jG, Blocks.field_204406_jG);
        coralMap.put(Blocks.field_203966_jH, Blocks.field_204407_jH);
        coralMap.put(Blocks.field_203967_jI, Blocks.field_204408_jI);
        coralMap.put(Blocks.field_204278_jJ, Blocks.field_212585_jY);
        coralMap.put(Blocks.field_204279_jK, Blocks.field_212586_jZ);
        coralMap.put(Blocks.field_204280_jL, Blocks.field_212587_ka);
        coralMap.put(Blocks.field_204281_jM, Blocks.field_212588_kb);
        coralMap.put(Blocks.field_204282_jN, Blocks.field_212589_kc);
        coralMap.put(Blocks.field_204743_jR, Blocks.field_211901_kp);
        coralMap.put(Blocks.field_204744_jS, Blocks.field_211902_kq);
        coralMap.put(Blocks.field_204745_jT, Blocks.field_211903_kr);
        coralMap.put(Blocks.field_204746_jU, Blocks.field_211904_ks);
        coralMap.put(Blocks.field_204747_jV, Blocks.field_211905_kt);
        coralMap.put(Blocks.field_211891_jY, Blocks.field_211896_kk);
        coralMap.put(Blocks.field_211892_jZ, Blocks.field_211897_kl);
        coralMap.put(Blocks.field_211893_ka, Blocks.field_211898_km);
        coralMap.put(Blocks.field_211894_kb, Blocks.field_211899_kn);
        coralMap.put(Blocks.field_211895_kc, Blocks.field_211900_ko);
    }
}

