/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.alchemy;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.API.templates.ConduitBlock;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.alchemy.AlchemicalTubeTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class AlchemicalTube
extends ConduitBlock<EnumTransferMode> {
    private static final double SIZE = 0.3125;
    protected static final VoxelShape[] SHAPES = AlchemicalTube.generateShapes(0.3125);
    protected final boolean crystal;

    public AlchemicalTube(boolean crystal) {
        this(crystal, (crystal ? "crystal_" : "") + "alch_tube");
    }

    protected AlchemicalTube(boolean crystal, String name) {
        super(Block.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.5f).func_200947_a(SoundType.field_185853_f));
        this.crystal = crystal;
        this.setRegistryName(name);
        CRBlocks.blockAddQue(this);
    }

    @Override
    protected Property<EnumTransferMode>[] getSideProp() {
        return CRProperties.CONDUIT_SIDES_SINGLE;
    }

    @Override
    protected VoxelShape[] getShapes() {
        return SHAPES;
    }

    @Override
    protected boolean evaluate(EnumTransferMode value, BlockState state, @Nullable ConduitBlock.IConduitTE<EnumTransferMode> te) {
        return value.isConnection();
    }

    @Override
    protected EnumTransferMode cycleMode(EnumTransferMode prev) {
        switch (prev) {
            case NONE: {
                return EnumTransferMode.INPUT;
            }
            case INPUT: {
                return EnumTransferMode.OUTPUT;
            }
        }
        return EnumTransferMode.NONE;
    }

    @Override
    protected double getSize() {
        return 0.3125;
    }

    @Override
    protected EnumTransferMode getDefaultValue() {
        return EnumTransferMode.NONE;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new AlchemicalTubeTileEntity(!this.crystal);
    }

    @Override
    protected EnumTransferMode getValueForPlacement(World world, BlockPos pos, Direction side, @Nullable TileEntity neighTE) {
        if (neighTE instanceof AlchemicalTubeTileEntity) {
            EnumTransferMode otherMode = ((AlchemicalTubeTileEntity)neighTE).getModes()[side.func_176734_d().func_176745_a()];
            if (otherMode == EnumTransferMode.OUTPUT) {
                return EnumTransferMode.INPUT;
            }
            if (otherMode == EnumTransferMode.INPUT) {
                return EnumTransferMode.OUTPUT;
            }
        }
        return EnumTransferMode.INPUT;
    }

    @Override
    protected void onAdjusted(World world, BlockPos pos, BlockState newState, Direction facing, EnumTransferMode newVal, @Nullable ConduitBlock.IConduitTE<EnumTransferMode> te) {
        super.onAdjusted(world, pos, newState, facing, newVal, te);
        TileEntity neighTE = world.func_175625_s(pos.func_177972_a(facing));
        if (neighTE instanceof AlchemicalTubeTileEntity && ((AlchemicalTube)neighTE.func_195044_w().func_177230_c()).crystal == this.crystal) {
            EnumTransferMode otherMode;
            switch (newVal) {
                case INPUT: {
                    otherMode = EnumTransferMode.OUTPUT;
                    break;
                }
                case OUTPUT: {
                    otherMode = EnumTransferMode.INPUT;
                    break;
                }
                default: {
                    otherMode = EnumTransferMode.NONE;
                }
            }
            ((AlchemicalTubeTileEntity)neighTE).setData(facing.func_176734_d().func_176745_a(), newVal.isConnection(), (Comparable)((Object)otherMode));
        }
    }
}

