/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.alchemy;

import com.Da_Technomancer.crossroads.API.alchemy.IReagent;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.alchemy.ReactionChamberTileEntity;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ReactionChamber
extends ContainerBlock {
    private static final String TAG_NAME = "reagents";
    private final boolean crystal;

    public ReactionChamber(boolean crystal) {
        super(Block.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.5f).func_200947_a(SoundType.field_185853_f).func_226896_b_());
        this.crystal = crystal;
        String name = (crystal ? "crystal_" : "") + "reaction_chamber";
        this.setRegistryName(name);
        CRBlocks.toRegister.add((Block)this);
        CRBlocks.blockAddQue(this);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new ReactionChamberTileEntity(!this.crystal);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stackIn) {
        if (!(te instanceof ReactionChamberTileEntity)) {
            super.func_180657_a(worldIn, player, pos, state, te, stackIn);
        } else {
            player.func_71020_j(0.005f);
            ItemStack stack = new ItemStack((IItemProvider)this, 1);
            this.setReagents(stack, ((ReactionChamberTileEntity)te).getMap());
            ReactionChamber.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            ReactionChamberTileEntity te = (ReactionChamberTileEntity)world.func_175625_s(pos);
            te.writeContentNBT(stack);
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof ReactionChamberTileEntity) {
            playerIn.func_184611_a(hand, ((ReactionChamberTileEntity)te).rightClickWithItem(playerIn.func_184586_b(hand), playerIn.func_225608_bj_(), playerIn, hand));
        }
        return ActionResultType.SUCCESS;
    }

    @Nonnull
    public static ReagentMap getReagants(ItemStack stack) {
        return stack.func_77942_o() ? ReagentMap.readFromNBT(stack.func_77978_p().func_74775_l(TAG_NAME)) : new ReagentMap();
    }

    public void setReagents(ItemStack stack, ReagentMap reagents) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT nbt = new CompoundNBT();
        stack.func_77978_p().func_218657_a(TAG_NAME, (INBT)nbt);
        reagents.write(nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ReagentMap stored = ReactionChamber.getReagants(stack);
        double temp = stored.getTempC();
        if (stored.getTotalQty() == 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.alchemy_empty", new Object[0]));
        } else {
            HeatUtil.addHeatInfo(tooltip, temp, -32768.0);
            int total = 0;
            for (IReagent type : stored.keySet()) {
                int qty = stored.getQty(type);
                if (qty <= 0) continue;
                if (++total > 4 && flagIn == ITooltipFlag.TooltipFlags.NORMAL) break;
                tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.alchemy_content", new Object[]{type.getName(), qty}));
            }
            if (total > 4 && flagIn == ITooltipFlag.TooltipFlags.NORMAL) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.alchemy_excess", new Object[]{total - 4}));
            }
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.reaction_chamber.power", new Object[]{10}));
    }
}

