/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.alchemy;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.alchemy.ReagentFilterTileEntity;
import com.Da_Technomancer.essentials.ESConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ReagentFilter
extends ContainerBlock {
    private static final VoxelShape SHAPE = ReagentFilter.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    private final boolean crystal;

    public ReagentFilter(boolean crystal) {
        super(Block.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.5f).func_200947_a(SoundType.field_185853_f));
        this.crystal = crystal;
        String name = (crystal ? "crystal_" : "") + "reagent_filter";
        this.setRegistryName(name);
        CRBlocks.toRegister.add((Block)this);
        CRBlocks.blockAddQue(this);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{CRProperties.HORIZ_FACING});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)CRProperties.HORIZ_FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new ReagentFilterTileEntity(this.crystal);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.reagent_filter.desc", new Object[0]));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.reagent_filter.filter", new Object[0]));
        tooltip.add(new TranslationTextComponent("tt.crossroads.reagent_filter.quip", new Object[0]).func_150255_a(MiscUtil.TT_QUIP));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (ESConfig.isWrench((ItemStack)playerIn.func_184586_b(hand))) {
                worldIn.func_175656_a(pos, (BlockState)state.func_177231_a((IProperty)CRProperties.HORIZ_FACING));
                if (te instanceof ReagentFilterTileEntity) {
                    ((ReagentFilterTileEntity)te).clearCache();
                }
            } else if (te instanceof INamedContainerProvider) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)((INamedContainerProvider)te), (BlockPos)pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof ReagentFilterTileEntity) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((ReagentFilterTileEntity)te));
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }
}

