/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.fluid;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.fluid.FluidTankTileEntity;
import com.Da_Technomancer.essentials.blocks.redstone.IReadable;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.network.NetworkHooks;

public class FluidTank
extends ContainerBlock
implements IReadable {
    public FluidTank() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200943_b(3.0f));
        String name = "fluid_tank";
        this.setRegistryName(name);
        CRBlocks.toRegister.add((Block)this);
        CRBlocks.blockAddQue(this);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new FluidTankTileEntity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("FluidName")) {
            FluidStack fStack = FluidStack.loadFluidStackFromNBT((CompoundNBT)stack.func_77978_p());
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.fluid_tank", new Object[]{fStack.getAmount(), fStack.getDisplayName().func_150254_d()}));
        }
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stackIn) {
        if (!(te instanceof FluidTankTileEntity) || ((FluidTankTileEntity)te).getContent().isEmpty()) {
            super.func_180657_a(worldIn, player, pos, state, te, stackIn);
        } else {
            player.func_71020_j(0.005f);
            ItemStack stack = new ItemStack((IItemProvider)this.func_199767_j(), 1);
            stack.func_77982_d(((FluidTankTileEntity)te).getContent().writeToNBT(new CompoundNBT()));
            FluidTank.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            FluidTankTileEntity te = (FluidTankTileEntity)world.func_175625_s(pos);
            te.setContent(FluidStack.loadFluidStackFromNBT((CompoundNBT)stack.func_77978_p()));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            if (FluidUtil.getFluidHandler((ItemStack)playerIn.func_184586_b(Hand.MAIN_HAND)).isPresent()) {
                return FluidUtil.interactWithFluidHandler((PlayerEntity)playerIn, (Hand)hand, (World)worldIn, (BlockPos)pos, null) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
            }
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof INamedContainerProvider) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)((INamedContainerProvider)te), (BlockPos)pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return RedstoneUtil.clampToVanilla((float)this.read(worldIn, pos, blockState));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public float read(World world, BlockPos pos, BlockState blockState) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FluidTankTileEntity) {
            return 15.0f * (float)((FluidTankTileEntity)te).getContent().getAmount() / 16000.0f;
        }
        return 0.0f;
    }
}

