/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.fluid;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.API.templates.ConduitBlock;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.fluid.FluidTubeTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class FluidTube
extends ConduitBlock<EnumTransferMode> {
    private static final double SIZE = 0.3125;
    protected static final VoxelShape[] SHAPES = FluidTube.generateShapes(0.3125);

    public FluidTube() {
        this("fluid_tube");
    }

    protected FluidTube(String name) {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200943_b(2.0f));
        this.setRegistryName(name);
        CRBlocks.blockAddQue(this);
    }

    @Override
    protected EnumTransferMode getDefaultValue() {
        return EnumTransferMode.NONE;
    }

    @Override
    protected double getSize() {
        return 0.3125;
    }

    @Override
    protected Property<EnumTransferMode>[] getSideProp() {
        return CRProperties.CONDUIT_SIDES_FULL;
    }

    @Override
    protected VoxelShape[] getShapes() {
        return SHAPES;
    }

    @Override
    protected boolean evaluate(EnumTransferMode value, BlockState state, @Nullable ConduitBlock.IConduitTE<EnumTransferMode> te) {
        return value.isConnection();
    }

    @Override
    protected EnumTransferMode cycleMode(EnumTransferMode prev) {
        switch (prev) {
            case INPUT: {
                return EnumTransferMode.OUTPUT;
            }
            case OUTPUT: {
                return EnumTransferMode.BOTH;
            }
            case BOTH: {
                return EnumTransferMode.NONE;
            }
        }
        return EnumTransferMode.INPUT;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new FluidTubeTileEntity();
    }

    @Override
    protected EnumTransferMode getValueForPlacement(World world, BlockPos pos, Direction side, @Nullable TileEntity neighTE) {
        if (neighTE instanceof FluidTubeTileEntity) {
            EnumTransferMode otherMode = ((FluidTubeTileEntity)neighTE).getModes()[side.func_176734_d().func_176745_a()];
            switch (otherMode) {
                case INPUT: {
                    return EnumTransferMode.OUTPUT;
                }
                case OUTPUT: {
                    return EnumTransferMode.INPUT;
                }
                case BOTH: {
                    return EnumTransferMode.BOTH;
                }
                case NONE: {
                    return EnumTransferMode.NONE;
                }
            }
        }
        return EnumTransferMode.INPUT;
    }

    @Override
    protected void onAdjusted(World world, BlockPos pos, BlockState newState, Direction facing, EnumTransferMode newVal, @Nullable ConduitBlock.IConduitTE<EnumTransferMode> te) {
        super.onAdjusted(world, pos, newState, facing, newVal, te);
        TileEntity neighTE = world.func_175625_s(pos.func_177972_a(facing));
        if (neighTE instanceof FluidTubeTileEntity) {
            EnumTransferMode otherMode;
            switch (newVal) {
                case INPUT: {
                    otherMode = EnumTransferMode.OUTPUT;
                    break;
                }
                case OUTPUT: {
                    otherMode = EnumTransferMode.INPUT;
                    break;
                }
                case BOTH: {
                    otherMode = EnumTransferMode.BOTH;
                    break;
                }
                default: {
                    otherMode = EnumTransferMode.NONE;
                }
            }
            ((FluidTubeTileEntity)neighTE).setData(facing.func_176734_d().func_176745_a(), otherMode.isConnection(), (Comparable)((Object)otherMode));
        }
    }
}

