/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.heat;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.API.heat.HeatInsulators;
import com.Da_Technomancer.crossroads.API.templates.ConduitBlock;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.crafting.CRItemTags;
import com.Da_Technomancer.crossroads.tileentities.heat.HeatCableTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class HeatCable
extends ConduitBlock<EnumTransferMode> {
    private static final double SIZE = 0.2;
    protected static final VoxelShape[] SHAPES = HeatCable.generateShapes(0.2);
    private static final Item.Properties itemProp = new Item.Properties().func_200916_a(CRItems.TAB_HEAT_CABLE);
    protected final HeatInsulators insulator;

    public HeatCable(HeatInsulators insulator) {
        this(insulator, "heat_cable_" + insulator.toString().toLowerCase());
    }

    protected HeatCable(HeatInsulators insulator, String name) {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(1.0f));
        this.insulator = insulator;
        this.setRegistryName(name);
        CRBlocks.blockAddQue(this, itemProp);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(CRProperties.CONDUCTOR, (Comparable)((Object)Conductors.COPPER)));
    }

    @Override
    protected double getSize() {
        return 0.2;
    }

    @Override
    protected EnumTransferMode getDefaultValue() {
        return EnumTransferMode.NONE;
    }

    @Override
    protected EnumTransferMode getValueForPlacement(World world, BlockPos pos, Direction side, @Nullable TileEntity neighTE) {
        return EnumTransferMode.BOTH;
    }

    @Override
    protected Property<EnumTransferMode>[] getSideProp() {
        return CRProperties.CONDUIT_SIDES_BASE;
    }

    @Override
    protected VoxelShape[] getShapes() {
        return SHAPES;
    }

    @Override
    protected boolean evaluate(EnumTransferMode value, BlockState state, @Nullable ConduitBlock.IConduitTE<EnumTransferMode> te) {
        return value.isConnection();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{CRProperties.CONDUCTOR});
    }

    @Override
    protected EnumTransferMode cycleMode(EnumTransferMode prev) {
        return prev.isConnection() ? EnumTransferMode.NONE : EnumTransferMode.BOTH;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (playerIn != null && hand != null) {
            if (!super.func_225533_a_(state, worldIn, pos, playerIn, hand, hit).func_226247_b_()) {
                Conductors match = null;
                Item item = playerIn.func_184586_b(hand).func_77973_b();
                for (Conductors c : Conductors.values()) {
                    if (!c.tag.func_199685_a_((Object)item)) continue;
                    match = c;
                    break;
                }
                if (match != null && state.func_177229_b(CRProperties.CONDUCTOR) != match) {
                    if (!worldIn.field_72995_K) {
                        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(CRProperties.CONDUCTOR, (Comparable)((Object)match)), 2);
                    }
                    return ActionResultType.SUCCESS;
                }
            } else {
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Override
    protected void onAdjusted(World world, BlockPos pos, BlockState newState, Direction facing, EnumTransferMode newVal, @Nullable ConduitBlock.IConduitTE<EnumTransferMode> te) {
        super.onAdjusted(world, pos, newState, facing, newVal, te);
        TileEntity neighTE = world.func_175625_s(pos.func_177972_a(facing));
        if (neighTE instanceof HeatCableTileEntity) {
            ((HeatCableTileEntity)neighTE).setData(facing.func_176734_d().func_176745_a(), newVal.isConnection(), (Comparable)((Object)newVal));
        }
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new HeatCableTileEntity(this.insulator);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.heat_cable.loss", new Object[]{this.insulator.getRate()}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.heat_cable.melt", new Object[]{this.insulator.getLimit()}));
    }

    public static enum Conductors implements IStringSerializable
    {
        COPPER(CRItemTags.INGOTS_COPPER),
        IRON((Tag<Item>)Tags.Items.INGOTS_IRON),
        QUARTZ((Tag<Item>)Tags.Items.GEMS_QUARTZ),
        DIAMOND((Tag<Item>)Tags.Items.GEMS_DIAMOND);

        public final Tag<Item> tag;

        private Conductors(Tag<Item> tag) {
            this.tag = tag;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public String func_176610_l() {
            return this.toString();
        }
    }
}

