/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.technomancy;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.technomancy.BeamCage;
import com.Da_Technomancer.crossroads.tileentities.technomancy.CageChargerTileEntity;
import com.Da_Technomancer.essentials.blocks.redstone.IReadable;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CageCharger
extends ContainerBlock
implements IReadable {
    private static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)CageCharger.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)CageCharger.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0));

    public CageCharger() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.0f).func_200947_a(SoundType.field_185852_e));
        String name = "cage_charger";
        this.setRegistryName(name);
        CRBlocks.toRegister.add((Block)this);
        CRBlocks.blockAddQue(this);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)CRProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{CRProperties.ACTIVE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new CageChargerTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.cage_charger.desc", new Object[0]));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.cage_charger.redstone", new Object[0]));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) != null) {
            if (((Boolean)state.func_177229_b((IProperty)CRProperties.ACTIVE)).booleanValue()) {
                playerIn.field_71071_by.func_70441_a(((CageChargerTileEntity)te).getCage());
                ((CageChargerTileEntity)te).setCage(ItemStack.field_190927_a);
                worldIn.func_175656_a(pos, (BlockState)this.func_176223_P().func_206870_a((IProperty)CRProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
            } else if (!playerIn.func_184586_b(hand).func_190926_b() && playerIn.func_184586_b(hand).func_77973_b() == CRItems.beamCage) {
                ((CageChargerTileEntity)te).setCage(playerIn.func_184586_b(hand));
                playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                worldIn.func_175656_a(pos, (BlockState)this.func_176223_P().func_206870_a((IProperty)CRProperties.ACTIVE, (Comparable)Boolean.valueOf(true)));
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && ((Boolean)state.func_177229_b((IProperty)CRProperties.ACTIVE)).booleanValue() && newState.func_177230_c() != this) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)((CageChargerTileEntity)world.func_175625_s(pos)).getCage());
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return RedstoneUtil.clampToVanilla((float)this.read(worldIn, pos, blockState));
    }

    public float read(World world, BlockPos pos, BlockState state) {
        TileEntity te;
        if (((Boolean)state.func_177229_b((IProperty)CRProperties.ACTIVE)).booleanValue() && (te = world.func_175625_s(pos)) instanceof CageChargerTileEntity) {
            ItemStack cage = ((CageChargerTileEntity)te).getCage();
            return BeamCage.getStored(cage).getPower();
        }
        return 0.0f;
    }
}

