/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.technomancy;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.technomancy.FluxUtil;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.technomancy.TemporalAcceleratorTileEntity;
import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TemporalAccelerator
extends ContainerBlock {
    private static final VoxelShape[] SHAPES = new VoxelShape[6];

    public TemporalAccelerator() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.0f).func_200947_a(SoundType.field_185852_e));
        String name = "temporal_accelerator";
        this.setRegistryName(name);
        CRBlocks.toRegister.add((Block)this);
        CRBlocks.blockAddQue(this);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(CRProperties.ACCELERATOR_TARGET, (Comparable)((Object)Mode.BOTH)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{ESProperties.FACING, CRProperties.ACCELERATOR_TARGET});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[((Direction)state.func_177229_b((IProperty)ESProperties.FACING)).func_176745_a()];
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)ESProperties.FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        ItemStack held = playerIn.func_184586_b(hand);
        if (FluxUtil.handleFluxLinking(worldIn, pos, held, playerIn).func_226247_b_()) {
            return ActionResultType.SUCCESS;
        }
        if (ESConfig.isWrench((ItemStack)held)) {
            if (playerIn.func_225608_bj_()) {
                TileEntity te = worldIn.func_175625_s(pos);
                state = (BlockState)state.func_177231_a(CRProperties.ACCELERATOR_TARGET);
                worldIn.func_175656_a(pos, state);
                if (te instanceof TemporalAcceleratorTileEntity) {
                    ((TemporalAcceleratorTileEntity)te).resetCache();
                }
                if (worldIn.field_72995_K) {
                    Mode newMode = (Mode)((Object)state.func_177229_b(CRProperties.ACCELERATOR_TARGET));
                    playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("tt.crossroads.time_accel.new_mode", new Object[]{MiscUtil.localize(newMode.getLocalizationName())}));
                    if (!((Boolean)CRConfig.teTimeAccel.get()).booleanValue() && newMode.accelerateTileEntities) {
                        playerIn.func_145747_a(new TranslationTextComponent("tt.crossroads.time_accel.config", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    }
                }
            } else {
                TileEntity te = worldIn.func_175625_s(pos);
                worldIn.func_175656_a(pos, (BlockState)state.func_177231_a((IProperty)ESProperties.FACING));
                if (te instanceof TemporalAcceleratorTileEntity) {
                    ((TemporalAcceleratorTileEntity)te).resetCache();
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TemporalAcceleratorTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.time_accel.desc", new Object[]{5}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.time_accel.beam", new Object[0]));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.time_accel.wrench", new Object[0]));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.time_accel.flux", new Object[0]));
    }

    static {
        TemporalAccelerator.SHAPES[0] = VoxelShapes.func_197872_a((VoxelShape)TemporalAccelerator.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)TemporalAccelerator.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0));
        TemporalAccelerator.SHAPES[1] = VoxelShapes.func_197872_a((VoxelShape)TemporalAccelerator.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)TemporalAccelerator.func_208617_a((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0));
        TemporalAccelerator.SHAPES[2] = VoxelShapes.func_197872_a((VoxelShape)TemporalAccelerator.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape)TemporalAccelerator.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)8.0));
        TemporalAccelerator.SHAPES[3] = VoxelShapes.func_197872_a((VoxelShape)TemporalAccelerator.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)TemporalAccelerator.func_208617_a((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)12.0));
        TemporalAccelerator.SHAPES[4] = VoxelShapes.func_197872_a((VoxelShape)TemporalAccelerator.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape)TemporalAccelerator.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0));
        TemporalAccelerator.SHAPES[5] = VoxelShapes.func_197872_a((VoxelShape)TemporalAccelerator.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)TemporalAccelerator.func_208617_a((double)8.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0));
    }

    public static enum Mode implements IStringSerializable
    {
        ENTITIES(true, false, false),
        BLOCKS(false, true, true),
        BOTH(true, true, true);

        public final boolean accelerateEntities;
        public final boolean accelerateTileEntities;
        public final boolean accelerateBlockTicks;

        private Mode(boolean entity, boolean te, boolean blockTicks) {
            this.accelerateEntities = entity;
            this.accelerateTileEntities = te;
            this.accelerateBlockTicks = blockTicks;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String getLocalizationName() {
            return "tt.crossroads.time_accel.mode." + this.func_176610_l();
        }
    }
}

