/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.gui;

import com.Da_Technomancer.crossroads.API.AdvancementTracker;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.templates.TextBarGuiObject;
import com.Da_Technomancer.crossroads.gui.container.ColorChartContainer;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class ColorChartScreen
extends ContainerScreen<ColorChartContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("crossroads", "textures/gui/container/color_chart_gui.png");
    private static final int xCENTER = 150;
    private static final int yCENTER = 150;
    private static final int RADIUS = 138;
    private TextBarGuiObject searchBar;

    public ColorChartScreen(ColorChartContainer cont, PlayerInventory playerInv, ITextComponent name) {
        super((Container)cont, playerInv, name);
        this.field_146999_f = 300;
        this.field_147000_g = 300;
    }

    public void init() {
        super.init();
        AdvancementTracker.listen();
        this.searchBar = new TextBarGuiObject((this.width - this.field_146999_f) / 2, (this.height - this.field_147000_g) / 2, 0, 300, 300, 25, "Filter", Character::isAlphabetic);
        this.children.add(this.searchBar);
    }

    private static Color getColor(int x, int y) {
        return Color.getHSBColor((float)(Math.atan2(y - 150, x - 150) / (Math.PI * 2)), (float)Math.min(Math.sqrt(Math.pow(x - 150, 2.0) + Math.pow(y - 150, 2.0)) / 138.0, 1.0), 1.0f);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        if (Math.pow(150 - mouseX + this.field_147003_i, 2.0) + Math.pow(150 - mouseY + this.field_147009_r, 2.0) <= 19044.0) {
            Color col = ColorChartScreen.getColor(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            EnumBeamAlignments elem = EnumBeamAlignments.getAlignment(col);
            this.renderTooltip((List)ImmutableList.of((Object)(elem.isDiscovered(this.field_213127_e.field_70458_d) ? elem.getLocalName(false) : "???"), (Object)("R: " + col.getRed() + ", G: " + col.getGreen() + ", B: " + col.getBlue())), mouseX, mouseY, this.font);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        ColorChartScreen.blit((int)i, (int)j, (float)300.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)1200, (int)1200);
        this.searchBar.drawBack(partialTicks, mouseX, mouseY, this.font);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String search = this.searchBar.getText().toUpperCase();
        this.searchBar.drawFore(mouseX, mouseY, this.font);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
        for (EnumBeamAlignments elem : EnumBeamAlignments.values()) {
            if (!elem.isDiscovered(this.field_213127_e.field_70458_d) || !search.isEmpty() && !elem.getLocalName(false).toLowerCase(Locale.US).startsWith(search.toLowerCase(Locale.US))) continue;
            int imageIndex = elem.ordinal() + 2;
            ColorChartScreen.blit((int)0, (int)0, (float)(this.field_146999_f * (imageIndex % 4)), (float)(this.field_146999_f * (imageIndex / 4)), (int)this.field_146999_f, (int)this.field_147000_g, (int)1200, (int)1200);
        }
    }

    public boolean mouseClicked(double x, double y, int button) {
        return this.searchBar.mouseClicked(x, y, button) || super.mouseClicked(x, y, button);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        for (IGuiEventListener gui : this.children) {
            if (!gui.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) continue;
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean charTyped(char key, int keyCode) {
        for (IGuiEventListener gui : this.children) {
            if (!gui.charTyped(key, keyCode)) continue;
            return true;
        }
        return super.charTyped(key, keyCode);
    }
}

