/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.integration.JEI;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentStack;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.integration.JEI.ReagIngr;
import com.Da_Technomancer.crossroads.integration.JEI.ReagentIngredientRenderer;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.crafting.recipes.AlchemyRec;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class AlchemyCategory
implements IRecipeCategory<AlchemyRec> {
    public static final ResourceLocation ID = new ResourceLocation("crossroads", "reaction");
    protected static final ResourceLocation ICONS = new ResourceLocation("crossroads", "textures/gui/icons.png");
    private final IDrawable back;
    private final IDrawableAnimated arrow;
    private final IDrawableStatic arrowStatic;
    private final IDrawable icon;
    private final IDrawable bolt;
    private final IDrawable blast;

    protected AlchemyCategory(IGuiHelper guiHelper) {
        this.back = guiHelper.createBlankDrawable(180, 100);
        this.arrowStatic = guiHelper.createDrawable(ICONS, 32, 0, 24, 16);
        this.arrow = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(ICONS, 32, 16, 24, 16), 40, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)CRItems.florenceFlaskCrystal, 1));
        this.bolt = guiHelper.createDrawable(ICONS, 16, 0, 16, 16);
        this.blast = guiHelper.createDrawable(ICONS, 64, 0, 16, 16);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends AlchemyRec> getRecipeClass() {
        return AlchemyRec.class;
    }

    public String getTitle() {
        return "Alchemical Reaction";
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(AlchemyRec recipe, IIngredients ingredients) {
        ArrayList<ReagIngr> reagents = new ArrayList<ReagIngr>(recipe.getReagents().length);
        for (ReagentStack reag : recipe.getReagents()) {
            reagents.add(new ReagIngr(reag));
        }
        ArrayList<ReagIngr> products = new ArrayList<ReagIngr>(recipe.getProducts().length);
        for (ReagentStack prod : recipe.getProducts()) {
            products.add(new ReagIngr(prod));
        }
        ingredients.setInputs(ReagIngr.REAG, reagents);
        ingredients.setOutputs(ReagIngr.REAG, products);
    }

    public void draw(AlchemyRec recipe, double mouseX, double mouseY) {
        this.arrowStatic.draw(78, 22);
        this.arrow.draw(78, 22);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        double maxTemp = recipe.maxTemp();
        String line = maxTemp <= 32667.0 ? MiscUtil.localize("crossroads.jei.alchemy.temp.dual", CRConfig.formatVal(Math.max(recipe.minTemp(), -273.0)), CRConfig.formatVal(maxTemp)) : MiscUtil.localize("crossroads.jei.alchemy.temp", CRConfig.formatVal(Math.max(recipe.minTemp(), -273.0)));
        fontRenderer.func_211126_b(line, 90.0f - (float)fontRenderer.func_78256_a(line) / 2.0f, 42.0f, 0x404040);
        line = recipe.deltaHeatPer() > 0.0 ? MiscUtil.localize("crossroads.jei.alchemy.cooling") : (recipe.deltaHeatPer() < 0.0 ? MiscUtil.localize("crossroads.jei.alchemy.heating") : MiscUtil.localize("crossroads.jei.alchemy.no_temp_change"));
        fontRenderer.func_211126_b(line, 90.0f - (float)fontRenderer.func_78256_a(line) / 2.0f, 62.0f, 0x404040);
        if (recipe.charged()) {
            this.bolt.draw(66, 2);
        }
        if (recipe.isDestructive()) {
            this.blast.draw(98, 2);
        }
        if (recipe.getCatalyst() != null) {
            ReagentIngredientRenderer.RENDERER.render(82, 2, new ReagIngr(recipe.getCatalyst(), 0));
        }
    }

    public IDrawable getBackground() {
        return this.back;
    }

    public void setRecipe(IRecipeLayout layout, AlchemyRec recipe, IIngredients ingredients) {
        IGuiIngredientGroup reagGroup = layout.getIngredientsGroup(ReagIngr.REAG);
        int inCount = recipe.getReagents().length;
        List reags = ingredients.getInputs(ReagIngr.REAG);
        for (int i = 0; i < inCount; ++i) {
            reagGroup.init(i, true, 60 - i * 20, 20);
            reagGroup.set(i, (List)reags.get(i));
        }
        int outCount = recipe.getProducts().length;
        List prods = ingredients.getOutputs(ReagIngr.REAG);
        for (int i = 0; i < outCount; ++i) {
            reagGroup.init(i + inCount, false, 105 + i * 20, 20);
            reagGroup.set(i + inCount, (List)prods.get(i));
        }
        reagGroup.set(ingredients);
    }

    public List<String> getTooltipStrings(AlchemyRec recipe, double mouseX, double mouseY) {
        if (recipe.getCatalyst() != null && mouseX >= 82.0 && mouseX <= 98.0 && mouseY >= 2.0 && mouseY <= 18.0) {
            return ImmutableList.of((Object)recipe.getCatalyst().getName());
        }
        return Collections.emptyList();
    }
}

