/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.integration.JEI;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.crafting.recipes.BeamExtractRec;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class BeamExtractorCategory
implements IRecipeCategory<BeamExtractRec> {
    public static final ResourceLocation ID = new ResourceLocation("crossroads", "beam_extractor");
    private final IDrawable back;
    private final IDrawable slot;
    private final IDrawable arrowStatic;
    private final IDrawable icon;

    protected BeamExtractorCategory(IGuiHelper guiHelper) {
        this.back = guiHelper.createBlankDrawable(180, 100);
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)CRBlocks.beamExtractor, 1));
        this.arrowStatic = guiHelper.createDrawable(new ResourceLocation("textures/gui/container/furnace.png"), 79, 35, 24, 17);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends BeamExtractRec> getRecipeClass() {
        return BeamExtractRec.class;
    }

    public String getTitle() {
        return CRBlocks.beamExtractor.func_200291_n().func_150254_d();
    }

    public IDrawable getBackground() {
        return this.back;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(BeamExtractRec recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
    }

    public void draw(BeamExtractRec rec, double mouseX, double mouseY) {
        this.slot.draw(20, 50);
        this.arrowStatic.draw(46, 50);
        Minecraft minecraft = Minecraft.func_71410_x();
        ArrayList<String> tt = new ArrayList<String>(4);
        if (rec.getOutput().getEnergy() != 0) {
            tt.add(MiscUtil.localize("crossroads.jei.extract.energy", rec.getOutput().getEnergy()));
        }
        if (rec.getOutput().getPotential() != 0) {
            tt.add(MiscUtil.localize("crossroads.jei.extract.potential", rec.getOutput().getPotential()));
        }
        if (rec.getOutput().getStability() != 0) {
            tt.add(MiscUtil.localize("crossroads.jei.extract.stability", rec.getOutput().getStability()));
        }
        if (rec.getOutput().getVoid() != 0) {
            tt.add(MiscUtil.localize("crossroads.jei.extract.void", rec.getOutput().getVoid()));
        }
        tt.add("");
        if (rec.getDuration() == 1) {
            tt.add(MiscUtil.localize("crossroads.jei.extract.duration.single", rec.getDuration()));
        } else {
            tt.add(MiscUtil.localize("crossroads.jei.extract.duration.plural", rec.getDuration()));
        }
        for (int i = 0; i < tt.size(); ++i) {
            minecraft.field_71466_p.func_211126_b((String)tt.get(i), 80.0f, (float)(5 + 20 * i), 0x404040);
        }
    }

    public void setRecipe(IRecipeLayout layout, BeamExtractRec recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemGroup = layout.getItemStacks();
        itemGroup.init(0, true, 20, 50);
        itemGroup.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
    }
}

