/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.integration.JEI;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.integration.JEI.JEICrossroadsPlugin;
import com.Da_Technomancer.crossroads.items.crafting.recipes.CentrifugeRec;
import com.google.common.collect.ImmutableList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class CentrifugeCategory
implements IRecipeCategory<CentrifugeRec> {
    public static final ResourceLocation ID = new ResourceLocation("crossroads", "centrifuge");
    private final IDrawable back;
    private final IDrawable icon;
    private final IDrawable slot;
    private final IDrawableAnimated arrow;
    private final IDrawableStatic arrowStatic;
    private final IDrawable fluidOverlay;

    protected CentrifugeCategory(IGuiHelper guiHelper) {
        this.back = guiHelper.createBlankDrawable(180, 100);
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)CRBlocks.waterCentrifuge, 1));
        this.arrowStatic = guiHelper.createDrawable(new ResourceLocation("textures/gui/container/furnace.png"), 79, 35, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(new ResourceLocation("textures/gui/container/furnace.png"), 176, 14, 24, 17), 40, IDrawableAnimated.StartDirection.LEFT, false);
        this.fluidOverlay = JEICrossroadsPlugin.createFluidOverlay(guiHelper);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends CentrifugeRec> getRecipeClass() {
        return CentrifugeRec.class;
    }

    public String getTitle() {
        return CRBlocks.waterCentrifuge.func_200291_n().func_150254_d();
    }

    public IDrawable getBackground() {
        return this.back;
    }

    public void draw(CentrifugeRec rec, double mouseX, double mouseY) {
        this.arrowStatic.draw(75, 56);
        this.arrow.draw(75, 56);
        this.slot.draw(130, 30);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CentrifugeRec recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemGroup = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidGroup = recipeLayout.getFluidStacks();
        itemGroup.init(0, false, 130, 30);
        itemGroup.set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        fluidGroup.init(0, true, 50, 30, 16, 64, 4000, true, this.fluidOverlay);
        fluidGroup.set(0, recipe.getInput());
        fluidGroup.init(1, false, 110, 30, 16, 64, 4000, true, this.fluidOverlay);
        fluidGroup.set(1, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CentrifugeRec recipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.FLUID, (Object)recipe.getInput());
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getFluidOutput());
        ingredients.setOutputLists(VanillaTypes.ITEM, (List)ImmutableList.of(recipe.getOutputList()));
    }
}

