/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.tileentities.rotary.WindingTableTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class Whirligig
extends Item
implements WindingTableTileEntity.IWindableItem {
    private static final double WIND_USE_RATE = 0.0016666666666666668;

    protected Whirligig() {
        super(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS).func_200917_a(1));
        this.func_185043_a(new ResourceLocation("angle"), (stack, world, entity) -> {
            if (entity == null || entity.func_184607_cu() != stack) {
                return 0.0f;
            }
            int useTime = entity.func_184612_cw();
            float currSpeed = (float)this.getWindLevel(stack) / 20.0f;
            float deaccel = 8.333333E-5f;
            float angle = (currSpeed * (float)useTime + deaccel * (float)useTime * (float)useTime / 2.0f) % ((float)Math.PI * 2);
            angle = (float)Math.toDegrees(angle);
            return angle;
        });
        String name = "whirligig";
        this.setRegistryName(name);
        CRItems.toRegister.add(this);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        double wind = this.getWindLevel(stack);
        double maxWind = this.getMaxWind();
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.spring_speed", new Object[]{CRConfig.formatVal(wind), CRConfig.formatVal(maxWind)}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.whirligig.desc", new Object[0]));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.whirligig.elevate", new Object[]{CRConfig.whirligigHover.get()}));
        tooltip.add(new TranslationTextComponent("tt.crossroads.whirligig.quip", new Object[0]).func_150255_a(MiscUtil.TT_QUIP));
    }

    @Override
    public double getMaxWind() {
        return 10.0;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack held = playerIn.func_184586_b(handIn);
        double wind = this.getWindLevel(held);
        if (wind > 0.0) {
            playerIn.func_184598_c(handIn);
            return ActionResult.func_226248_a_((Object)held);
        }
        return ActionResult.func_226251_d_((Object)held);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player.func_70613_aW()) {
            double wind = this.getWindLevel(stack);
            if (wind > 0.0) {
                double SLOWFALL_WIND = (Double)CRConfig.whirligigSafe.get();
                double HOVER_WIND = (Double)CRConfig.whirligigHover.get();
                player.field_70143_R = wind >= SLOWFALL_WIND ? 0.0f : (float)((double)player.field_70143_R * (1.0 - 0.2 * (wind / SLOWFALL_WIND)));
                if (player.func_226278_cu_() < 250.0) {
                    double gravity = 0.08;
                    double thrust = 0.08 * (wind / HOVER_WIND);
                    player.func_70024_g(0.0, thrust, 0.0);
                    player.field_70133_I = true;
                }
                wind = Math.max(wind - 0.0016666666666666668, 0.0);
                this.setWindLevel(stack, wind);
            } else {
                player.func_184602_cy();
            }
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this, 1));
            ItemStack stack = new ItemStack((IItemProvider)this, 1);
            this.setWindLevel(stack, this.getMaxWind());
            items.add((Object)stack);
        }
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }
}

