/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.crafting;

import com.Da_Technomancer.crossroads.items.crafting.recipes.BlockIngredient;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class CraftingUtil {
    public static FluidStack getFluidStack(JsonObject json, String memberName) {
        JsonObject obj = JSONUtils.func_152754_s((JsonObject)json, (String)memberName);
        String name = JSONUtils.func_151200_h((JsonObject)obj, (String)"fluid");
        Fluid f = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(name));
        int qty = JSONUtils.func_151203_m((JsonObject)obj, (String)"amount");
        return f == null || qty <= 0 ? FluidStack.EMPTY : new FluidStack(f, qty);
    }

    public static FluidStack getFluidStack(JsonObject json, String memberName, FluidStack fallback) {
        FluidStack out;
        try {
            out = CraftingUtil.getFluidStack(json, memberName);
        }
        catch (JsonParseException | IllegalArgumentException e) {
            out = fallback;
        }
        return out;
    }

    public static ItemStack getItemStack(JsonObject json, String memberName, boolean allowDirect, boolean nbt) {
        if (allowDirect && json.has("item")) {
            return CraftingHelper.getItemStack((JsonObject)json, (boolean)nbt);
        }
        if (memberName.isEmpty()) {
            throw new JsonSyntaxException("No item defined");
        }
        return CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject(memberName), (boolean)nbt);
    }

    public static ItemStack getItemStack(JsonObject json, String memberName, boolean allowDirect, boolean nbt, ItemStack fallback) {
        ItemStack out;
        try {
            out = CraftingUtil.getItemStack(json, memberName, allowDirect, nbt);
        }
        catch (JsonParseException | IllegalArgumentException e) {
            out = fallback;
        }
        return out;
    }

    public static Ingredient getIngredient(JsonElement json, String memberName, boolean allowDirect) {
        JsonObject jsonO;
        if (json.isJsonObject() && (jsonO = (JsonObject)json).has(memberName)) {
            return Ingredient.func_199802_a((JsonElement)((JsonObject)json).get(memberName));
        }
        if (allowDirect) {
            return Ingredient.func_199802_a((JsonElement)json);
        }
        throw new JsonParseException("Non-Ingredient passed as JSON ingredient");
    }

    public static BlockIngredient getBlockIngredient(JsonElement json, String memberName, boolean allowDirect) {
        JsonObject jsonO;
        if (json.isJsonObject() && (jsonO = (JsonObject)json).has(memberName)) {
            return BlockIngredient.readFromJSON(((JsonObject)json).get(memberName));
        }
        if (allowDirect) {
            return BlockIngredient.readFromJSON(json);
        }
        throw new JsonParseException("Non-BlockIngredient passed as JSON ingredient");
    }

    public static boolean isActiveJSON(JsonObject json) {
        return JSONUtils.func_151209_a((JsonObject)json, (String)"active", (boolean)true);
    }
}

