/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.crafting.recipes;

import com.Da_Technomancer.crossroads.API.alchemy.AlchemyCore;
import com.Da_Technomancer.crossroads.API.alchemy.EnumReagents;
import com.Da_Technomancer.crossroads.API.alchemy.IElementReagent;
import com.Da_Technomancer.crossroads.API.alchemy.IReactionChamber;
import com.Da_Technomancer.crossroads.API.alchemy.IReagent;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentStack;
import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.CraftingUtil;
import com.Da_Technomancer.crossroads.items.crafting.recipes.IOptionalRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AlchemyRec
implements IOptionalRecipe<IInventory> {
    private static final float MAX_BLAST = 8.0f;
    private final ResourceLocation id;
    private final String group;
    private final Type type;
    private final double heatChange;
    private final double minTemp;
    private final double maxTemp;
    private final IReagent cat;
    private final boolean charged;
    private final ReagentStack[] reagents;
    private final ReagentStack[] products;
    private final int amountChange;
    private final float data;
    private final boolean real;

    public AlchemyRec(ResourceLocation location, String name, Type type, ReagentStack[] reagents, ReagentStack[] products, @Nullable IReagent cat, double minTemp, double maxTemp, double heatChange, boolean charged, float data, boolean real) {
        this.id = location;
        this.group = name;
        this.type = type;
        this.reagents = reagents;
        this.products = products;
        this.cat = cat;
        this.minTemp = minTemp;
        this.maxTemp = maxTemp;
        this.heatChange = heatChange;
        this.charged = charged;
        this.data = data;
        this.real = real;
        int change = 0;
        for (ReagentStack reag : reagents) {
            change -= reag.getAmount();
        }
        for (ReagentStack prod : products) {
            change += prod.getAmount();
        }
        this.amountChange = change;
    }

    @Nullable
    public IReagent getCatalyst() {
        return this.cat;
    }

    public double minTemp() {
        return this.minTemp;
    }

    public double maxTemp() {
        return this.maxTemp;
    }

    public boolean charged() {
        return this.charged;
    }

    public double deltaHeatPer() {
        return this.heatChange;
    }

    public ReagentStack[] getReagents() {
        return this.reagents;
    }

    public ReagentStack[] getProducts() {
        return this.products;
    }

    public boolean isDestructive() {
        return this.type == Type.DESTRUCTIVE || this.type == Type.PRECISE;
    }

    @Override
    public boolean isEnabled() {
        return this.real;
    }

    public boolean performReaction(IReactionChamber chamb) {
        if (!this.real) {
            return false;
        }
        if (this.type == Type.ELEMENTAL) {
            if (chamb.isCharged()) {
                IElementReagent prod = (IElementReagent)this.products[0].getType();
                ReagentMap reags = chamb.getReagants();
                if (reags.getQty(EnumReagents.PRACTITIONER.id()) != 0 && prod.getAlignment() == EnumBeamAlignments.getAlignment(new BeamUnit(reags.getQty(EnumReagents.PHELOSTOGEN.id()), reags.getQty(EnumReagents.AETHER.id()), reags.getQty(EnumReagents.ADAMANT.id()), 0))) {
                    int created = 0;
                    created += reags.getQty(EnumReagents.PHELOSTOGEN.id());
                    created += reags.getQty(EnumReagents.AETHER.id());
                    created += reags.getQty(EnumReagents.ADAMANT.id());
                    reags.remove(AlchemyCore.REAGENTS.get(EnumReagents.PHELOSTOGEN.id()));
                    reags.remove(AlchemyCore.REAGENTS.get(EnumReagents.AETHER.id()));
                    reags.remove(AlchemyCore.REAGENTS.get(EnumReagents.ADAMANT.id()));
                    reags.addReagent(prod, created, reags.getTempC());
                    return created > 0;
                }
            }
            return false;
        }
        if (this.charged() && !chamb.isCharged()) {
            return false;
        }
        ReagentMap reags = chamb.getReagants();
        if (this.cat != null && reags.getQty(this.cat) <= 0) {
            return false;
        }
        double chambTemp = chamb.getTemp();
        if (chambTemp > this.maxTemp() || chambTemp < this.minTemp()) {
            return false;
        }
        int content = chamb.getContent();
        int maxReactions = this.amountChange <= 0 ? 200 : (chamb.getReactionCapacity() - content) / this.amountChange;
        int prevMax = 0;
        for (ReagentStack reag : this.reagents) {
            if (reags.getQty(reag.getType()) <= 0) {
                return false;
            }
            int maxFromReag = reags.getQty(reag.getType()) / reag.getAmount();
            maxReactions = Math.min(maxReactions, maxFromReag);
            if (this.type != Type.PRECISE || maxReactions <= 0) continue;
            if (prevMax != 0 && prevMax != maxFromReag) {
                chamb.destroyChamber(0.0f);
                continue;
            }
            prevMax = maxFromReag;
        }
        double deltaHeat = this.deltaHeatPer();
        if (deltaHeat != 0.0) {
            double allowedTempChange = deltaHeat < 0.0 ? this.maxTemp() - chambTemp : this.minTemp() - chambTemp;
            maxReactions = Math.min(maxReactions, (int)Math.max(1.0, (double)(-content) * allowedTempChange / (deltaHeat + (double)this.amountChange * allowedTempChange)));
        }
        if (maxReactions <= 0) {
            return false;
        }
        for (ReagentStack reag : this.getProducts()) {
            reags.addReagent(reag.getType(), maxReactions * reag.getAmount(), reags.getTempC());
        }
        for (ReagentStack reag : this.getReagents()) {
            reags.removeReagent(reag.getType(), maxReactions * reag.getAmount());
        }
        reags.setTemp(HeatUtil.toCelcius((reags.getTempK() * (double)reags.getTotalQty() - deltaHeat * (double)maxReactions) / (double)reags.getTotalQty()));
        if (this.type == Type.DESTRUCTIVE) {
            chamb.destroyChamber(Math.min(8.0f, this.data * (float)maxReactions));
            chamb.addVisualEffect(ParticleTypes.field_197601_L, 0.0, 0.0, 0.0);
        }
        return true;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return true;
    }

    @Override
    public ItemStack func_77572_b(IInventory inv) {
        return this.func_77571_b();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)CRItems.florenceFlaskCrystal);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CRRecipes.ALCHEMY_SERIAL;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeType<?> func_222127_g() {
        return CRRecipes.ALCHEMY_TYPE;
    }

    public static enum Type {
        NORMAL,
        PRECISE,
        DESTRUCTIVE,
        ELEMENTAL;


        public static Type getType(String s) {
            s = s.toUpperCase(Locale.ENGLISH);
            for (Type t : Type.values()) {
                if (!t.name().equals(s)) continue;
                return t;
            }
            return NORMAL;
        }
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AlchemyRec> {
        private static final String VOID_STR = "NONE";

        public AlchemyRec read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            boolean real = CraftingUtil.isActiveJSON(json);
            if (real) {
                JsonArray jsonR;
                Type type = Type.getType(JSONUtils.func_151219_a((JsonObject)json, (String)"category", (String)"normal"));
                double minTemp = JSONUtils.func_151221_a((JsonObject)json, (String)"min_temp", (float)-300.0f);
                double maxTemp = JSONUtils.func_151221_a((JsonObject)json, (String)"max_temp", (float)32767.0f);
                double heatChange = JSONUtils.func_151221_a((JsonObject)json, (String)"heat", (float)0.0f);
                String s = JSONUtils.func_151219_a((JsonObject)json, (String)"catalyst", (String)VOID_STR);
                IReagent cat = s.equals(VOID_STR) ? null : AlchemyCore.REAGENTS.get(s);
                boolean charge = JSONUtils.func_151209_a((JsonObject)json, (String)"charged", (boolean)false);
                float data = JSONUtils.func_151221_a((JsonObject)json, (String)"data", (float)0.0f);
                if (JSONUtils.func_151202_d((JsonObject)json, (String)"reagents")) {
                    jsonR = JSONUtils.func_151214_t((JsonObject)json, (String)"reagents");
                } else {
                    jsonR = new JsonArray();
                    jsonR.add((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"reagents"));
                }
                ReagentStack[] reags = new ReagentStack[jsonR.size()];
                for (int i = 0; i < reags.length; ++i) {
                    JsonElement elem = jsonR.get(i);
                    if (!(elem instanceof JsonObject)) continue;
                    JsonObject obj = (JsonObject)elem;
                    IReagent reagent = AlchemyCore.REAGENTS.get(JSONUtils.func_151200_h((JsonObject)obj, (String)"type"));
                    assert (reagent != null);
                    reags[i] = new ReagentStack(reagent, JSONUtils.func_151208_a((JsonObject)obj, (String)"qty", (int)1));
                }
                if (JSONUtils.func_151202_d((JsonObject)json, (String)"products")) {
                    jsonR = JSONUtils.func_151214_t((JsonObject)json, (String)"products");
                } else {
                    jsonR = new JsonArray();
                    jsonR.add((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"products"));
                }
                ReagentStack[] prods = new ReagentStack[jsonR.size()];
                for (int i = 0; i < prods.length; ++i) {
                    JsonElement elem = jsonR.get(i);
                    if (!(elem instanceof JsonObject)) continue;
                    JsonObject obj = (JsonObject)elem;
                    IReagent reagent = AlchemyCore.REAGENTS.get(JSONUtils.func_151200_h((JsonObject)obj, (String)"type"));
                    assert (reagent != null);
                    prods[i] = new ReagentStack(reagent, JSONUtils.func_151208_a((JsonObject)obj, (String)"qty", (int)1));
                }
                return new AlchemyRec(recipeId, group, type, reags, prods, cat, minTemp, maxTemp, heatChange, charge, data, true);
            }
            return new AlchemyRec(recipeId, group, Type.NORMAL, new ReagentStack[0], new ReagentStack[0], null, -273.0, -273.0, 0.0, false, 0.0f, false);
        }

        @Nullable
        public AlchemyRec read(ResourceLocation recipeId, PacketBuffer buffer) {
            boolean real = buffer.readBoolean();
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            if (real) {
                Type type = Type.values()[buffer.readByte()];
                float heatChange = buffer.readFloat();
                float minTemp = buffer.readFloat();
                float maxTemp = buffer.readFloat();
                String s = buffer.func_150789_c(Short.MAX_VALUE);
                IReagent catalyst = s.equals(VOID_STR) ? null : AlchemyCore.REAGENTS.get(s);
                boolean charged = buffer.readBoolean();
                ReagentStack[] reags = new ReagentStack[buffer.readByte()];
                for (int i = 0; i < reags.length; ++i) {
                    reags[i] = new ReagentStack(AlchemyCore.REAGENTS.get(buffer.func_218666_n()), buffer.readByte());
                }
                ReagentStack[] prod = new ReagentStack[buffer.readByte()];
                for (int i = 0; i < prod.length; ++i) {
                    prod[i] = new ReagentStack(AlchemyCore.REAGENTS.get(buffer.func_218666_n()), buffer.readByte());
                }
                float data = buffer.readFloat();
                return new AlchemyRec(recipeId, group, type, reags, prod, catalyst, minTemp, maxTemp, heatChange, charged, data, true);
            }
            return new AlchemyRec(recipeId, group, Type.NORMAL, new ReagentStack[0], new ReagentStack[0], null, -273.0, -273.0, 0.0, false, 0.0f, false);
        }

        public void write(PacketBuffer buffer, AlchemyRec recipe) {
            buffer.writeBoolean(recipe.real);
            buffer.func_180714_a(recipe.func_193358_e());
            if (recipe.real) {
                buffer.writeByte(recipe.type.ordinal());
                buffer.writeFloat((float)recipe.heatChange);
                buffer.writeFloat((float)recipe.minTemp);
                buffer.writeFloat((float)recipe.maxTemp);
                buffer.func_180714_a(recipe.cat == null ? VOID_STR : recipe.cat.getId());
                buffer.writeBoolean(recipe.charged);
                int total = recipe.reagents.length;
                buffer.writeByte(total);
                for (ReagentStack reag : recipe.reagents) {
                    buffer.func_180714_a(reag.getType().getId());
                    buffer.writeByte(reag.getAmount());
                }
                total = recipe.products.length;
                buffer.writeByte(total);
                for (ReagentStack reag : recipe.products) {
                    buffer.func_180714_a(reag.getType().getId());
                    buffer.writeByte(reag.getAmount());
                }
                buffer.writeFloat(recipe.data);
            }
        }
    }
}

