/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.crafting.recipes;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.CraftingUtil;
import com.Da_Technomancer.crossroads.items.crafting.recipes.IOptionalRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CrucibleRec
implements IOptionalRecipe<IInventory> {
    private final ResourceLocation id;
    private final String group;
    private final Ingredient input;
    private final FluidStack output;
    private final boolean active;

    public CrucibleRec(ResourceLocation location, String name, Ingredient input, FluidStack output, boolean active) {
        this.id = location;
        this.group = name;
        this.input = input;
        this.output = output;
        this.active = active;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    @Override
    public boolean isEnabled() {
        return this.active;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.active && this.input.test(inv.func_70301_a(0));
    }

    @Override
    public ItemStack func_77572_b(IInventory inv) {
        return this.func_77571_b();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)CRBlocks.heatingCrucible);
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.add((Object)this.input);
        return nonnulllist;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CRRecipes.CRUCIBLE_SERIAL;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeType<?> func_222127_g() {
        return CRRecipes.CRUCIBLE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CrucibleRec> {
        public CrucibleRec read(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            if (!CraftingUtil.isActiveJSON(json)) {
                return new CrucibleRec(recipeId, s, Ingredient.field_193370_a, FluidStack.EMPTY, false);
            }
            Ingredient in = CraftingUtil.getIngredient((JsonElement)json, "input", true);
            FluidStack out = CraftingUtil.getFluidStack(json, "output");
            return new CrucibleRec(recipeId, s, in, out, true);
        }

        @Nullable
        public CrucibleRec read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            if (!buffer.readBoolean()) {
                return new CrucibleRec(recipeId, s, Ingredient.field_193370_a, FluidStack.EMPTY, false);
            }
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            FluidStack output = FluidStack.readFromPacket((PacketBuffer)buffer);
            return new CrucibleRec(recipeId, s, input, output, true);
        }

        public void write(PacketBuffer buffer, CrucibleRec recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.writeBoolean(recipe.active);
            recipe.input.func_199564_a(buffer);
            recipe.output.writeToPacket(buffer);
        }
    }
}

