/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.crafting.recipes;

import com.Da_Technomancer.crossroads.API.EnumPath;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.CraftingUtil;
import com.Da_Technomancer.crossroads.items.crafting.recipes.IOptionalRecipe;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class DetailedCrafterRec
extends ShapedRecipe
implements IOptionalRecipe<CraftingInventory> {
    private final EnumPath path;
    private final boolean active;

    public DetailedCrafterRec(ResourceLocation idIn, String groupIn, EnumPath path, boolean active, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(idIn, groupIn, recipeWidthIn, recipeHeightIn, recipeItemsIn, recipeOutputIn);
        this.path = path;
        this.active = active;
    }

    public EnumPath getPath() {
        return this.path;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)CRBlocks.detailedCrafter);
    }

    @Override
    public boolean isEnabled() {
        return this.active;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CRRecipes.DETAILED_SERIAL;
    }

    public IRecipeType<?> func_222127_g() {
        return CRRecipes.DETAILED_TYPE;
    }

    public boolean func_77569_a(CraftingInventory inv, World world) {
        return this.active && super.func_77569_a(inv, world);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<DetailedCrafterRec> {
        public DetailedCrafterRec read(ResourceLocation recipeId, JsonObject json) {
            if (!CraftingUtil.isActiveJSON(json)) {
                return new DetailedCrafterRec(recipeId, "", EnumPath.ALCHEMY, false, 0, 0, (NonNullList<Ingredient>)NonNullList.func_191196_a(), ItemStack.field_190927_a);
            }
            EnumPath path = EnumPath.fromName(JSONUtils.func_151200_h((JsonObject)json, (String)"path"));
            if (path == null) {
                throw new JsonParseException("Invalid path/no path set");
            }
            ShapedRecipe templateRec = (ShapedRecipe)IRecipeSerializer.field_222157_a.func_199425_a_(recipeId, json);
            return new DetailedCrafterRec(recipeId, templateRec.func_193358_e(), path, true, templateRec.getRecipeWidth(), templateRec.getRecipeHeight(), (NonNullList<Ingredient>)templateRec.func_192400_c(), templateRec.func_77571_b());
        }

        public DetailedCrafterRec read(ResourceLocation recipeId, PacketBuffer buffer) {
            if (!buffer.readBoolean()) {
                return new DetailedCrafterRec(recipeId, "", EnumPath.ALCHEMY, false, 0, 0, (NonNullList<Ingredient>)NonNullList.func_191196_a(), ItemStack.field_190927_a);
            }
            EnumPath path = EnumPath.fromIndex(buffer.readByte());
            ShapedRecipe templateRec = (ShapedRecipe)IRecipeSerializer.field_222157_a.func_199426_a_(recipeId, buffer);
            return new DetailedCrafterRec(recipeId, templateRec.func_193358_e(), path, true, templateRec.getRecipeWidth(), templateRec.getRecipeHeight(), (NonNullList<Ingredient>)templateRec.func_192400_c(), templateRec.func_77571_b());
        }

        public void write(PacketBuffer buffer, DetailedCrafterRec recipe) {
            buffer.writeBoolean(recipe.active);
            buffer.writeByte((int)recipe.path.getIndex());
            IRecipeSerializer.field_222157_a.func_199427_a_(buffer, (IRecipe)recipe);
        }
    }
}

