/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.crafting.recipes;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.CraftingUtil;
import com.Da_Technomancer.crossroads.items.crafting.recipes.IOptionalRecipe;
import com.Da_Technomancer.crossroads.tileentities.heat.FluidCoolingChamberTileEntity;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FluidCoolingRec
implements IOptionalRecipe<IInventory> {
    private final ResourceLocation id;
    private final String group;
    private final FluidStack input;
    private final ItemStack created;
    private final float maxTemp;
    private final float addedHeat;
    private final boolean active;

    public FluidCoolingRec(ResourceLocation location, String name, FluidStack input, ItemStack output, float maxTemp, float addedHeat, boolean active) {
        this.id = location;
        this.group = name;
        this.input = input;
        this.created = output;
        this.maxTemp = maxTemp;
        this.addedHeat = addedHeat;
        this.active = active;
    }

    @Override
    public boolean isEnabled() {
        return this.active;
    }

    public FluidStack getInput() {
        return this.input;
    }

    public ItemStack getCreated() {
        return this.created;
    }

    public float getMaxTemp() {
        return this.maxTemp;
    }

    public float getAddedHeat() {
        return this.addedHeat;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.active && inv instanceof FluidCoolingChamberTileEntity && BlockUtil.sameFluid((FluidStack)((FluidCoolingChamberTileEntity)inv).getFluid(), (FluidStack)this.input);
    }

    @Override
    public ItemStack func_77572_b(IInventory inv) {
        return this.func_77571_b().func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.created;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)CRBlocks.fluidCoolingChamber);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CRRecipes.FLUID_COOLING_SERIAL;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeType<?> func_222127_g() {
        return CRRecipes.FLUID_COOLING_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<FluidCoolingRec> {
        public FluidCoolingRec read(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            if (!CraftingUtil.isActiveJSON(json)) {
                return new FluidCoolingRec(recipeId, s, FluidStack.EMPTY, ItemStack.field_190927_a, 0.0f, 0.0f, false);
            }
            FluidStack input = CraftingUtil.getFluidStack(json, "input");
            ItemStack output = CraftingUtil.getItemStack(json, "output", true, false);
            float maxTemp = JSONUtils.func_151217_k((JsonObject)json, (String)"max_temp");
            float tempChange = JSONUtils.func_151221_a((JsonObject)json, (String)"temp_change", (float)0.0f);
            return new FluidCoolingRec(recipeId, s, input, output, maxTemp, tempChange, true);
        }

        @Nullable
        public FluidCoolingRec read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            if (!buffer.readBoolean()) {
                return new FluidCoolingRec(recipeId, s, FluidStack.EMPTY, ItemStack.field_190927_a, 0.0f, 0.0f, false);
            }
            FluidStack input = FluidStack.readFromPacket((PacketBuffer)buffer);
            ItemStack output = buffer.func_150791_c();
            float maxTemp = buffer.readFloat();
            float tempChange = buffer.readFloat();
            return new FluidCoolingRec(recipeId, s, input, output, maxTemp, tempChange, true);
        }

        public void write(PacketBuffer buffer, FluidCoolingRec recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.writeBoolean(recipe.active);
            recipe.getInput().writeToPacket(buffer);
            buffer.func_150788_a(recipe.func_77571_b());
            buffer.writeFloat(recipe.getMaxTemp());
            buffer.writeFloat(recipe.getAddedHeat());
        }
    }
}

