/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.crafting.recipes;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.CraftingUtil;
import com.Da_Technomancer.crossroads.items.crafting.recipes.IOptionalRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class IceboxRec
implements IOptionalRecipe<IInventory> {
    private final ResourceLocation id;
    private final String group;
    private final Ingredient ingr;
    private final float cooling;
    private final boolean active;

    public IceboxRec(ResourceLocation location, String name, Ingredient input, double cooling, boolean active) {
        this.id = location;
        this.group = name;
        this.ingr = input;
        this.cooling = (float)cooling;
        this.active = active;
    }

    public float getCooling() {
        return this.cooling;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.add((Object)this.ingr);
        return nonnulllist;
    }

    @Override
    public boolean isEnabled() {
        return this.active;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.active && this.ingr.test(inv.func_70301_a(0));
    }

    @Override
    public ItemStack func_77572_b(IInventory inv) {
        return this.func_77571_b();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)CRBlocks.icebox);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CRRecipes.COOLING_SERIAL;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeType<?> func_222127_g() {
        return CRRecipes.COOLING_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<IceboxRec> {
        public IceboxRec read(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            if (!CraftingUtil.isActiveJSON(json)) {
                return new IceboxRec(recipeId, s, Ingredient.field_193370_a, 0.0, false);
            }
            Ingredient ingredient = CraftingUtil.getIngredient((JsonElement)json, "fuel", false);
            double cooling = JSONUtils.func_151217_k((JsonObject)json, (String)"cooling");
            return new IceboxRec(recipeId, s, ingredient, cooling, true);
        }

        @Nullable
        public IceboxRec read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            if (!buffer.readBoolean()) {
                return new IceboxRec(recipeId, s, Ingredient.field_193370_a, 0.0, false);
            }
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            float cooling = buffer.readFloat();
            return new IceboxRec(recipeId, s, ingredient, cooling, true);
        }

        public void write(PacketBuffer buffer, IceboxRec recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.writeBoolean(recipe.active);
            recipe.ingr.func_199564_a(buffer);
            buffer.writeFloat(recipe.cooling);
        }
    }
}

