/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.crafting.recipes;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.CraftingUtil;
import com.Da_Technomancer.crossroads.items.crafting.recipes.IOptionalRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MillRec
implements IOptionalRecipe<IInventory> {
    private final ResourceLocation id;
    private final String group;
    private final Ingredient ingr;
    private final ItemStack[] outputs;
    private final boolean active;

    public MillRec(ResourceLocation location, String name, Ingredient input, boolean active, ItemStack ... output) {
        this.id = location;
        this.group = name;
        this.ingr = input;
        this.active = active;
        this.outputs = output;
    }

    public ItemStack[] getOutputs() {
        return this.outputs;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.add((Object)this.ingr);
        return nonnulllist;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.ingr.test(inv.func_70301_a(0));
    }

    @Override
    public ItemStack func_77572_b(IInventory inv) {
        return this.func_77571_b().func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.outputs.length != 0 ? this.outputs[0].func_77946_l() : ItemStack.field_190927_a;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)CRBlocks.millstone);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CRRecipes.MILL_SERIAL;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeType<?> func_222127_g() {
        return CRRecipes.MILL_TYPE;
    }

    @Override
    public boolean isEnabled() {
        return this.active;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<MillRec> {
        public MillRec read(ResourceLocation recipeId, JsonObject json) {
            ItemStack[] outputs;
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            if (!CraftingUtil.isActiveJSON(json)) {
                return new MillRec(recipeId, s, Ingredient.field_193370_a, false, new ItemStack[0]);
            }
            Ingredient ingredient = CraftingUtil.getIngredient((JsonElement)json, "input", true);
            if (JSONUtils.func_151202_d((JsonObject)json, (String)"output")) {
                JsonArray array = JSONUtils.func_151214_t((JsonObject)json, (String)"output");
                outputs = new ItemStack[Math.min(3, array.size())];
                for (int i = 0; i < outputs.length; ++i) {
                    JsonObject outputObj = array.get(i).getAsJsonObject();
                    outputs[i] = CraftingUtil.getItemStack(outputObj, "", true, false);
                }
            } else {
                outputs = new ItemStack[]{CraftingUtil.getItemStack(json, "output", false, false)};
            }
            return new MillRec(recipeId, s, ingredient, true, outputs);
        }

        @Nullable
        public MillRec read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            if (!buffer.readBoolean()) {
                return new MillRec(recipeId, s, Ingredient.field_193370_a, false, new ItemStack[0]);
            }
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            int outputCount = buffer.readByte();
            ItemStack[] outputs = new ItemStack[outputCount];
            for (int i = 0; i < outputCount; ++i) {
                outputs[i] = buffer.func_150791_c();
            }
            return new MillRec(recipeId, s, ingredient, true, outputs);
        }

        public void write(PacketBuffer buffer, MillRec recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.writeBoolean(recipe.active);
            recipe.ingr.func_199564_a(buffer);
            buffer.writeByte(recipe.outputs.length);
            for (ItemStack stack : recipe.outputs) {
                buffer.func_150788_a(stack);
            }
        }
    }
}

