/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.technomancy;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.beams.BeamUtil;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.beams.IBeamHandler;
import com.Da_Technomancer.crossroads.integration.curios.CurioHelper;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.technomancy.BeamCage;
import com.Da_Technomancer.crossroads.items.technomancy.BeamUsingItem;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class StaffTechnomancy
extends BeamUsingItem {
    private static final int MAX_RANGE = 64;

    public StaffTechnomancy() {
        super(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS).func_200917_a(1));
        String name = "staff_technomancy";
        this.setRegistryName(name);
        CRItems.toRegister.add(this);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        playerIn.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (!player.field_70170_p.field_72995_K && player.func_70089_S() && (this.func_77626_a(stack) - count) % 4 == 0) {
            BeamUnit cageBeam;
            ItemStack cage = CurioHelper.getEquipped(CRItems.beamCage, player);
            byte[] setting = StaffTechnomancy.getSetting(stack);
            if (setting[0] <= (cageBeam = BeamCage.getStored(cage)).getEnergy() && setting[1] <= cageBeam.getPotential() && setting[2] <= cageBeam.getStability() && setting[3] <= cageBeam.getVoid() && setting[0] + setting[1] + setting[2] + setting[3] != 0) {
                BeamCage.storeBeam(cage, new BeamUnit(cageBeam.getEnergy() - setting[0], cageBeam.getPotential() - setting[1], cageBeam.getStability() - setting[2], cageBeam.getVoid() - setting[3]));
                BeamUnit mag = new BeamUnit(setting[0], setting[1], setting[2], setting[3]);
                double heldOffset = 0.22 * (player.func_184600_cs() == Hand.MAIN_HAND ^ player.func_184591_cq() == HandSide.LEFT ? 1.0 : -1.0);
                Vec3d start = new Vec3d(player.func_226277_ct_() - heldOffset * Math.cos(Math.toRadians(player.field_70177_z)), player.func_226278_cu_() + (double)player.func_70047_e() + 0.4, player.func_226281_cx_() - heldOffset * Math.sin(Math.toRadians(player.field_70177_z)));
                double[] end = new double[]{player.func_226277_ct_(), (double)player.func_70047_e() + player.func_226278_cu_(), player.func_226281_cx_()};
                BlockPos endPos = null;
                Vec3d look = player.func_70040_Z().func_186678_a(0.2);
                Direction collisionDir = Direction.func_210769_a((double)look.field_72450_a, (double)look.field_72448_b, (double)look.field_72449_c);
                Direction effectDir = null;
                for (double d = 0.0; d < 64.0; d += 0.2) {
                    VoxelShape shape;
                    BlockRayTraceResult res;
                    BlockState state;
                    end[0] = end[0] + look.field_72450_a;
                    end[1] = end[1] + look.field_72448_b;
                    end[2] = end[2] + look.field_72449_c;
                    List ents = player.field_70170_p.func_175674_a((Entity)player, new AxisAlignedBB(end[0] - 0.1, end[1] - 0.1, end[2] - 0.1, end[0] + 0.1, end[1] + 0.1, end[2] + 0.1), EntityPredicates.field_94557_a);
                    if (!ents.isEmpty()) {
                        Optional res2 = ((Entity)ents.get(0)).func_174813_aQ().func_216365_b(start, new Vec3d(end[0], end[1], end[2]));
                        if (!res2.isPresent()) break;
                        Vec3d hitVec = (Vec3d)res2.get();
                        end[0] = hitVec.field_72450_a;
                        end[1] = hitVec.field_72448_b;
                        end[2] = hitVec.field_72449_c;
                        break;
                    }
                    BlockPos newEndPos = new BlockPos(end[0], end[1], end[2]);
                    if (newEndPos.equals(endPos) || World.func_189509_E((BlockPos)newEndPos) || !BeamUtil.solidToBeams(state = player.field_70170_p.func_180495_p(endPos = newEndPos), player.field_70170_p, endPos, collisionDir, mag.getPower()) || (res = (shape = state.func_196951_e((IBlockReader)player.field_70170_p, endPos)).func_212433_a(start, new Vec3d(end[0] + look.field_72450_a * 5.0, end[1] + look.field_72448_b * 5.0, end[2] + look.field_72449_c * 5.0), endPos)) == null) continue;
                    Vec3d hitVec = res.func_216347_e();
                    end[0] = hitVec.field_72450_a;
                    end[1] = hitVec.field_72448_b;
                    end[2] = hitVec.field_72449_c;
                    effectDir = res.func_216354_b();
                    break;
                }
                if (endPos != null) {
                    LazyOptional opt;
                    TileEntity te = player.field_70170_p.func_175625_s(endPos);
                    if (te != null && (opt = te.getCapability(Capabilities.BEAM_CAPABILITY, effectDir)).isPresent()) {
                        ((IBeamHandler)opt.orElseThrow(NullPointerException::new)).setBeam(mag);
                    } else {
                        EnumBeamAlignments align = EnumBeamAlignments.getAlignment(mag);
                        if (!World.func_189509_E(endPos)) {
                            align.getEffect().doBeamEffect(align, mag.getVoid() != 0, Math.min(64, mag.getPower()), player.field_70170_p, endPos, effectDir);
                        }
                    }
                }
                Vec3d beamVec = new Vec3d(end[0] - start.field_72450_a, end[1] - start.field_72448_b, end[2] - start.field_72449_c);
                CRRenderUtil.addBeam(player.field_70170_p, start.field_72450_a, start.field_72448_b, start.field_72449_c, beamVec.func_72433_c(), (float)Math.toDegrees(Math.atan2(-beamVec.field_72448_b, Math.sqrt(beamVec.field_72450_a * beamVec.field_72450_a + beamVec.field_72449_c * beamVec.field_72449_c))), (float)Math.toDegrees(Math.atan2(-beamVec.field_72450_a, beamVec.field_72449_c)), (byte)Math.round(Math.sqrt(mag.getPower())), mag.getRGB().getRGB());
            }
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 9.0, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -3.1, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    @Override
    protected byte maxSetting() {
        return 8;
    }
}

