/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.render.TESR;

import com.Da_Technomancer.crossroads.API.beams.BeamManager;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.render.CRRenderTypes;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.render.TESR.BeamRenderer;
import com.Da_Technomancer.crossroads.tileentities.technomancy.BeaconHarnessTileEntity;
import com.Da_Technomancer.essentials.render.LinkLineRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import org.apache.commons.lang3.tuple.Triple;

public class BeaconHarnessRenderer
extends LinkLineRenderer<BeaconHarnessTileEntity> {
    protected BeaconHarnessRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(BeaconHarnessTileEntity te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        super.func_225616_a_((TileEntity)te, partialTicks, matrix, buffer, combinedLight, combinedOverlay);
        IVertexBuilder beamBuilder = buffer.getBuffer(CRRenderTypes.BEAM_TYPE);
        matrix.func_227861_a_(0.5, 0.0, 0.5);
        float angle = 0.0f;
        int[] beamPacket = te.getRenderedBeams();
        Triple<Color, Integer, Integer> trip = BeamManager.getTriple(beamPacket[0]);
        if ((Integer)trip.getRight() != 0) {
            angle = BeaconHarnessRenderer.calcAngle(te, partialTicks);
            matrix.func_227860_a_();
            matrix.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            float width = ((Integer)trip.getRight()).floatValue() / 8.0f / (float)Math.sqrt(2.0);
            int length = (Integer)trip.getMiddle();
            boolean doRotation = (Boolean)CRConfig.rotateBeam.get();
            Quaternion verticalRot = doRotation ? Vector3f.field_229181_d_.func_229187_a_(CRRenderUtil.getRenderTime(partialTicks, te.func_145831_w()) * 2.0f) : Vector3f.field_229181_d_.func_229187_a_(45.0f);
            matrix.func_227861_a_(0.0, -0.5, 0.0);
            matrix.func_227863_a_(verticalRot);
            BeamRenderer.drawBeam(matrix, beamBuilder, length, width, (Color)trip.getLeft());
            matrix.func_227865_b_();
        }
        float smallOffset = 0.0928f;
        float medOffset = 0.25f;
        float largeOffset = 0.375f;
        int mediumLight = CRRenderUtil.calcMediumLighting(combinedLight);
        TextureAtlasSprite copSprite = CRRenderUtil.getTextureSprite(CRRenderTypes.COPSHOWIUM_TEXTURE);
        TextureAtlasSprite quartzSprite = CRRenderUtil.getTextureSprite(CRRenderTypes.QUARTZ_TEXTURE);
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228639_c_());
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
        BeaconHarnessRenderer.addRod(matrix, builder, smallOffset, smallOffset, copSprite, mediumLight);
        BeaconHarnessRenderer.addRod(matrix, builder, smallOffset, -smallOffset, copSprite, mediumLight);
        BeaconHarnessRenderer.addRod(matrix, builder, -smallOffset, -smallOffset, copSprite, mediumLight);
        BeaconHarnessRenderer.addRod(matrix, builder, -smallOffset, smallOffset, copSprite, mediumLight);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-2.0f * angle));
        BeaconHarnessRenderer.addRod(matrix, builder, medOffset, largeOffset, quartzSprite, mediumLight);
        BeaconHarnessRenderer.addRod(matrix, builder, medOffset, -largeOffset, quartzSprite, mediumLight);
        BeaconHarnessRenderer.addRod(matrix, builder, -medOffset, largeOffset, quartzSprite, mediumLight);
        BeaconHarnessRenderer.addRod(matrix, builder, -medOffset, -largeOffset, quartzSprite, mediumLight);
        BeaconHarnessRenderer.addRod(matrix, builder, largeOffset, medOffset, quartzSprite, mediumLight);
        BeaconHarnessRenderer.addRod(matrix, builder, largeOffset, -medOffset, quartzSprite, mediumLight);
        BeaconHarnessRenderer.addRod(matrix, builder, -largeOffset, medOffset, quartzSprite, mediumLight);
        BeaconHarnessRenderer.addRod(matrix, builder, -largeOffset, -medOffset, quartzSprite, mediumLight);
    }

    private static void addRod(MatrixStack matrix, IVertexBuilder builder, float x, float z, TextureAtlasSprite sprite, int light) {
        float rad = 0.0625f;
        float minY = 0.0625f;
        float maxY = 0.9375f;
        float uEn = sprite.func_94214_a((double)(2.0f * rad * 16.0f));
        float vEn = sprite.func_94207_b((double)(2.0f * rad * 16.0f));
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x - rad), (float)minY, (float)(z - rad), (float)sprite.func_94209_e(), (float)sprite.func_94206_g(), (float)0.0f, (float)0.0f, (float)-1.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x - rad), (float)maxY, (float)(z - rad), (float)sprite.func_94209_e(), (float)sprite.func_94210_h(), (float)0.0f, (float)0.0f, (float)-1.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x + rad), (float)maxY, (float)(z - rad), (float)uEn, (float)sprite.func_94210_h(), (float)0.0f, (float)0.0f, (float)-1.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x + rad), (float)minY, (float)(z - rad), (float)uEn, (float)sprite.func_94206_g(), (float)0.0f, (float)0.0f, (float)-1.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x - rad), (float)minY, (float)(z + rad), (float)sprite.func_94209_e(), (float)sprite.func_94206_g(), (float)0.0f, (float)0.0f, (float)1.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x + rad), (float)minY, (float)(z + rad), (float)uEn, (float)sprite.func_94206_g(), (float)0.0f, (float)0.0f, (float)1.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x + rad), (float)maxY, (float)(z + rad), (float)uEn, (float)sprite.func_94210_h(), (float)0.0f, (float)0.0f, (float)1.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x - rad), (float)maxY, (float)(z + rad), (float)sprite.func_94209_e(), (float)sprite.func_94210_h(), (float)0.0f, (float)0.0f, (float)1.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x - rad), (float)minY, (float)(z - rad), (float)sprite.func_94209_e(), (float)sprite.func_94206_g(), (float)-1.0f, (float)0.0f, (float)0.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x - rad), (float)minY, (float)(z + rad), (float)uEn, (float)sprite.func_94206_g(), (float)-1.0f, (float)0.0f, (float)0.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x - rad), (float)maxY, (float)(z + rad), (float)uEn, (float)sprite.func_94210_h(), (float)-1.0f, (float)0.0f, (float)0.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x - rad), (float)maxY, (float)(z - rad), (float)sprite.func_94209_e(), (float)sprite.func_94210_h(), (float)-1.0f, (float)0.0f, (float)0.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x + rad), (float)minY, (float)(z - rad), (float)sprite.func_94209_e(), (float)sprite.func_94206_g(), (float)1.0f, (float)0.0f, (float)0.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x + rad), (float)maxY, (float)(z - rad), (float)sprite.func_94209_e(), (float)sprite.func_94210_h(), (float)1.0f, (float)0.0f, (float)0.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x + rad), (float)maxY, (float)(z + rad), (float)uEn, (float)sprite.func_94210_h(), (float)1.0f, (float)0.0f, (float)0.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x + rad), (float)minY, (float)(z + rad), (float)uEn, (float)sprite.func_94206_g(), (float)1.0f, (float)0.0f, (float)0.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x + rad), (float)minY, (float)(z + rad), (float)sprite.func_94209_e(), (float)sprite.func_94206_g(), (float)0.0f, (float)-1.0f, (float)0.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x - rad), (float)minY, (float)(z + rad), (float)uEn, (float)sprite.func_94206_g(), (float)0.0f, (float)-1.0f, (float)0.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x - rad), (float)minY, (float)(z - rad), (float)uEn, (float)vEn, (float)0.0f, (float)-1.0f, (float)0.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(x + rad), (float)minY, (float)(z - rad), (float)sprite.func_94209_e(), (float)vEn, (float)0.0f, (float)-1.0f, (float)0.0f, (int)light);
    }

    private static float calcAngle(BeaconHarnessTileEntity te, float partialTicks) {
        return (float)Math.toDegrees(CRRenderUtil.getRenderTime(partialTicks, te.func_145831_w()) * (float)Math.PI / 20.0f);
    }

    public boolean isGlobalRenderer(BeaconHarnessTileEntity te) {
        return true;
    }
}

