/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.render.TESR;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.render.TESR.BeamRenderer;
import com.Da_Technomancer.crossroads.tileentities.beams.LensFrameTileEntity;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class LensFrameRenderer
extends BeamRenderer<LensFrameTileEntity> {
    private static final ResourceLocation[] LENS_FRAME_TEXTURES = new ResourceLocation[6];

    protected LensFrameRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(LensFrameTileEntity beam, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        super.func_225616_a_(beam, partialTicks, matrix, buffer, combinedLight, combinedOverlay);
        BlockState state = beam.func_195044_w();
        int content = beam.getContents();
        if (content != 0 && state.func_177230_c() == CRBlocks.lensFrame) {
            Direction.Axis axis = (Direction.Axis)state.func_177229_b((IProperty)ESProperties.AXIS);
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.5, 0.5, 0.5);
            switch (axis) {
                case X: {
                    matrix.func_227863_a_(Direction.WEST.func_229384_a_());
                    break;
                }
                case Z: {
                    matrix.func_227863_a_(Direction.NORTH.func_229384_a_());
                }
            }
            IVertexBuilder builder = buffer.getBuffer(RenderType.func_228643_e_());
            float scale = 0.5f;
            float height = 0.1f;
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(LENS_FRAME_TEXTURES[content - 1]);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(-scale), (float)height, (float)(-scale), (float)sprite.func_94209_e(), (float)sprite.func_94206_g(), (float)0.0f, (float)1.0f, (float)0.0f, (int)combinedLight);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(-scale), (float)height, (float)scale, (float)sprite.func_94209_e(), (float)sprite.func_94210_h(), (float)0.0f, (float)1.0f, (float)0.0f, (int)combinedLight);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)scale, (float)height, (float)scale, (float)sprite.func_94212_f(), (float)sprite.func_94210_h(), (float)0.0f, (float)1.0f, (float)0.0f, (int)combinedLight);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)scale, (float)height, (float)(-scale), (float)sprite.func_94212_f(), (float)sprite.func_94206_g(), (float)0.0f, (float)1.0f, (float)0.0f, (int)combinedLight);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(-scale), (float)(-height), (float)(-scale), (float)sprite.func_94209_e(), (float)sprite.func_94206_g(), (float)0.0f, (float)1.0f, (float)0.0f, (int)combinedLight);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)scale, (float)(-height), (float)(-scale), (float)sprite.func_94212_f(), (float)sprite.func_94206_g(), (float)0.0f, (float)1.0f, (float)0.0f, (int)combinedLight);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)scale, (float)(-height), (float)scale, (float)sprite.func_94212_f(), (float)sprite.func_94210_h(), (float)0.0f, (float)1.0f, (float)0.0f, (int)combinedLight);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)(-scale), (float)(-height), (float)scale, (float)sprite.func_94209_e(), (float)sprite.func_94210_h(), (float)0.0f, (float)1.0f, (float)0.0f, (int)combinedLight);
            matrix.func_227865_b_();
        }
    }

    static {
        LensFrameRenderer.LENS_FRAME_TEXTURES[0] = new ResourceLocation("crossroads", "item/gem_ruby");
        LensFrameRenderer.LENS_FRAME_TEXTURES[1] = new ResourceLocation("item/emerald");
        LensFrameRenderer.LENS_FRAME_TEXTURES[2] = new ResourceLocation("item/diamond");
        LensFrameRenderer.LENS_FRAME_TEXTURES[3] = new ResourceLocation("crossroads", "item/pure_quartz");
        LensFrameRenderer.LENS_FRAME_TEXTURES[4] = new ResourceLocation("crossroads", "item/glow_quartz");
        LensFrameRenderer.LENS_FRAME_TEXTURES[5] = new ResourceLocation("crossroads", "item/void_crystal");
    }
}

