/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.render.TESR;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.render.TESR.CRModels;
import com.Da_Technomancer.crossroads.tileentities.fluid.RotaryPumpTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.common.util.LazyOptional;

public class RotaryPumpRenderer
extends TileEntityRenderer<RotaryPumpTileEntity> {
    protected RotaryPumpRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(RotaryPumpTileEntity te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.0, 0.5);
        LazyOptional<IAxleHandler> opt = te.getCapability(Capabilities.AXLE_CAPABILITY, null);
        if (opt.isPresent()) {
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((IAxleHandler)opt.orElseThrow(NullPointerException::new)).getAngle(partialTicks)));
        }
        CRModels.renderScrew(matrix, buffer, combinedLight);
        matrix.func_227865_b_();
        if (te.getCompletion() != 0.0f) {
            BlockPos fPos = te.func_174877_v().func_177972_a(Direction.DOWN);
            IFluidState state = te.func_145831_w().func_204610_c(fPos);
            if (state.func_206888_e() || !state.func_206889_d()) {
                return;
            }
            ResourceLocation textLoc = state.func_206886_c().getAttributes().getStillTexture();
            TextureAtlasSprite lText = CRRenderUtil.getTextureSprite(textLoc);
            Color fCol = new Color(state.func_206886_c().getAttributes().getColor((ILightReader)te.func_145831_w(), fPos));
            int[] cols = new int[]{fCol.getRed(), fCol.getGreen(), fCol.getBlue(), fCol.getAlpha()};
            float xSt = 0.1875f;
            float ySt = 0.0f;
            float zSt = 0.1875f;
            float xEn = 0.8125f;
            float yEn = 0.4375f * te.getCompletion();
            float zEn = 0.8125f;
            float uSt = lText.func_94214_a((double)(xSt * 16.0f));
            float uEn = lText.func_94214_a((double)(xEn * 16.0f));
            float vSt = lText.func_94207_b((double)(16.0f - ySt * 16.0f));
            float vEn = lText.func_94207_b((double)(16.0f - yEn * 16.0f));
            IVertexBuilder builder = buffer.getBuffer(RenderType.func_228647_g_());
            CRRenderUtil.addVertexBlock(builder, matrix, xEn, ySt, zSt, uEn, vSt, 0.0f, 0.0f, -1.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xSt, ySt, zSt, uSt, vSt, 0.0f, 0.0f, -1.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xSt, yEn, zSt, uSt, vEn, 0.0f, 0.0f, -1.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xEn, yEn, zSt, uEn, vEn, 0.0f, 0.0f, -1.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xSt, ySt, zEn, uSt, vSt, 0.0f, 0.0f, 1.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xEn, ySt, zEn, uEn, vSt, 0.0f, 0.0f, 1.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xEn, yEn, zEn, uEn, vEn, 0.0f, 0.0f, 1.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xSt, yEn, zEn, uSt, vEn, 0.0f, 0.0f, 1.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xSt, ySt, zSt, uSt, vSt, -1.0f, 0.0f, 0.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xSt, ySt, zEn, uEn, vSt, -1.0f, 0.0f, 0.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xSt, yEn, zEn, uEn, vEn, -1.0f, 0.0f, 0.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xSt, yEn, zSt, uSt, vEn, -1.0f, 0.0f, 0.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xEn, yEn, zSt, uEn, vSt, 1.0f, 0.0f, 0.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xEn, yEn, zEn, uEn, vEn, 1.0f, 0.0f, 0.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xEn, ySt, zEn, uSt, vEn, 1.0f, 0.0f, 0.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xEn, ySt, zSt, uSt, vSt, 1.0f, 0.0f, 0.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xSt, yEn, zSt, lText.func_94209_e(), lText.func_94206_g(), 0.0f, 1.0f, 0.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xSt, yEn, zEn, lText.func_94209_e(), lText.func_94210_h(), 0.0f, 1.0f, 0.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xEn, yEn, zEn, lText.func_94212_f(), lText.func_94210_h(), 0.0f, 1.0f, 0.0f, combinedLight, cols);
            CRRenderUtil.addVertexBlock(builder, matrix, xEn, yEn, zSt, lText.func_94212_f(), lText.func_94206_g(), 0.0f, 1.0f, 0.0f, combinedLight, cols);
        }
    }
}

