/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.alchemy;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.alchemy.AlchemyUtil;
import com.Da_Technomancer.crossroads.API.alchemy.EnumContainerType;
import com.Da_Technomancer.crossroads.API.alchemy.EnumMatterPhase;
import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.API.alchemy.IChemicalHandler;
import com.Da_Technomancer.crossroads.API.alchemy.IReagent;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentStack;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import java.util.HashSet;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class ChemicalVentTileEntity
extends TileEntity
implements ITickableTileEntity {
    @ObjectHolder(value="chemical_vent")
    private static TileEntityType<ChemicalVentTileEntity> type = null;
    private long lastInputTime = 0L;
    private ReagentMap reags = new ReagentMap();
    private static final int CYCLES = 10;
    private final LazyOptional<IChemicalHandler> alcOpt = LazyOptional.of(() -> new AlchHandler());

    public ChemicalVentTileEntity() {
        super(type);
    }

    public void func_73660_a() {
        if (!this.reags.isEmpty() && this.field_145850_b.func_82737_E() - this.lastInputTime >= 18L) {
            AlchemyUtil.releaseChemical(this.field_145850_b, this.field_174879_c, this.reags);
            this.reags = new ReagentMap();
        }
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.lastInputTime = nbt.func_74763_f("last_input");
        this.reags = ReagentMap.readFromNBT(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74772_a("last_input", this.lastInputTime);
        this.reags.write(nbt);
        return nbt;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.alcOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.CHEMICAL_CAPABILITY) {
            return this.alcOpt;
        }
        return super.getCapability(cap, side);
    }

    private class AlchHandler
    implements IChemicalHandler {
        private AlchHandler() {
        }

        @Override
        public EnumTransferMode getMode(Direction side) {
            return EnumTransferMode.INPUT;
        }

        @Override
        public EnumContainerType getChannel(Direction side) {
            return EnumContainerType.NONE;
        }

        @Override
        public int getTransferCapacity() {
            return 10;
        }

        @Override
        public double getTemp() {
            return -273.0;
        }

        @Override
        public boolean insertReagents(ReagentMap reag, Direction side, IChemicalHandler caller, boolean ignorePhase) {
            double callerTemp = reag.getTempK();
            HashSet<String> validIds = new HashSet<String>(4);
            for (IReagent type : reag.keySet()) {
                ReagentStack r = reag.getStack(type);
                if (r.isEmpty()) continue;
                EnumMatterPhase phase = type.getPhase(HeatUtil.toCelcius(callerTemp));
                if (!ignorePhase && (!phase.flows() || side == Direction.UP && !phase.flowsDown() || side == Direction.DOWN && !phase.flowsUp())) continue;
                validIds.add(type.getId());
            }
            boolean acted = false;
            for (String id : validIds) {
                int moved = reag.getQty(id);
                if (moved == 0) continue;
                ChemicalVentTileEntity.this.reags.transferReagent(id, moved, reag);
                acted = true;
            }
            if (acted && ChemicalVentTileEntity.this.field_145850_b.func_82737_E() - ChemicalVentTileEntity.this.lastInputTime > 18L) {
                ChemicalVentTileEntity.this.lastInputTime = ChemicalVentTileEntity.this.field_145850_b.func_82737_E();
            }
            return acted;
        }

        @Override
        public int getContent(IReagent type) {
            return 0;
        }
    }
}

