/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.alchemy;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.alchemy.AlchemyCarrierTE;
import com.Da_Technomancer.crossroads.API.alchemy.EnumContainerType;
import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.API.alchemy.IChemicalHandler;
import com.Da_Technomancer.crossroads.API.alchemy.IReagent;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.blocks.alchemy.ReagentFilter;
import com.Da_Technomancer.crossroads.gui.container.ReagentFilterContainer;
import com.Da_Technomancer.crossroads.items.alchemy.AbstractGlassware;
import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class ReagentFilterTileEntity
extends AlchemyCarrierTE
implements INamedContainerProvider,
IInventory {
    @ObjectHolder(value="reagent_filter")
    private static TileEntityType<ReagentFilterTileEntity> type = null;
    private Direction facing = null;
    private ItemStack inventory = ItemStack.field_190927_a;

    public ReagentFilterTileEntity() {
        super(type);
    }

    public ReagentFilterTileEntity(boolean crystal) {
        super(type, !crystal);
    }

    private Direction getFacing() {
        if (this.field_145850_b == null) {
            return Direction.NORTH;
        }
        if (this.facing == null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof ReagentFilter)) {
                return Direction.NORTH;
            }
            this.facing = (Direction)state.func_177229_b((IProperty)CRProperties.HORIZ_FACING);
        }
        return this.facing;
    }

    public void clearCache() {
        this.facing = null;
        this.chemOpt.invalidate();
        this.chemOpt = LazyOptional.of(() -> this.handler);
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.inventory = nbt.func_74764_b("inv") ? ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("inv")) : ItemStack.field_190927_a;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (!this.inventory.func_190926_b()) {
            nbt.func_218657_a("inv", (INBT)this.inventory.func_77955_b(new CompoundNBT()));
        }
        return nbt;
    }

    @Override
    protected void performTransfer() {
        ReagentMap filterMap = new ReagentMap();
        if (!this.contents.isEmpty() && !this.inventory.func_190926_b() && this.inventory.func_77973_b() instanceof AbstractGlassware && this.inventory.func_77942_o()) {
            ReagentMap filtered = ((AbstractGlassware)this.inventory.func_77973_b()).getReagants(this.inventory);
            for (IReagent filtReag : filtered.keySet()) {
                if (filtered.getQty(filtReag) == 0) continue;
                filterMap.transferReagent(filtReag, this.contents.getQty(filtReag), this.contents);
            }
        }
        boolean transfered = this.transfer(this.contents, Direction.DOWN);
        boolean bl = transfered = this.transfer(filterMap, this.getFacing()) || transfered;
        if (!filterMap.isEmpty()) {
            for (IReagent filtReag : filterMap.keySet()) {
                int qty = filterMap.getQty(filtReag);
                if (qty == 0) continue;
                this.contents.transferReagent(filtReag, qty, filterMap);
            }
        }
        this.dirtyReag |= transfered;
    }

    private boolean transfer(ReagentMap toTrans, Direction side) {
        LazyOptional chemOpt;
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
        if (toTrans.getTotalQty() <= 0 || te == null || !(chemOpt = te.getCapability(Capabilities.CHEMICAL_CAPABILITY, side.func_176734_d())).isPresent()) {
            return false;
        }
        IChemicalHandler otherHandler = (IChemicalHandler)chemOpt.orElseThrow(NullPointerException::new);
        EnumContainerType cont = otherHandler.getChannel(side.func_176734_d());
        if (cont == EnumContainerType.GLASS != this.glass) {
            return false;
        }
        return otherHandler.insertReagents(toTrans, side.func_176734_d(), this.handler, true);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (facing == this.getFacing() || facing != null && facing.func_176740_k() == Direction.Axis.Y) {
            return this.chemOpt;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @Nonnull
    protected EnumTransferMode[] getModes() {
        EnumTransferMode[] modes = new EnumTransferMode[]{EnumTransferMode.OUTPUT, EnumTransferMode.INPUT, EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE};
        modes[this.getFacing().func_176745_a()] = EnumTransferMode.OUTPUT;
        return modes;
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        return this.inventory.func_190926_b();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (count >= 1) {
            return this.func_70304_b(index);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (index == 0) {
            ItemStack removed = this.inventory;
            this.inventory = ItemStack.field_190927_a;
            this.func_70296_d();
            return removed;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index == 0) {
            this.inventory = stack;
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)((float)this.field_174879_c.func_177952_p() + 0.5f)) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && stack.func_77973_b() instanceof AbstractGlassware;
    }

    public void func_174888_l() {
        this.inventory = ItemStack.field_190927_a;
        this.func_70296_d();
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.reagent_filter", new Object[0]);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new ReagentFilterContainer(id, playerInv, new PacketBuffer(Unpooled.buffer()).func_179255_a(this.field_174879_c));
    }
}

