/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.alchemy;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.alchemy.AlchemyCarrierTE;
import com.Da_Technomancer.crossroads.API.alchemy.AlchemyUtil;
import com.Da_Technomancer.crossroads.API.alchemy.EnumContainerType;
import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.API.alchemy.IChemicalHandler;
import com.Da_Technomancer.crossroads.API.alchemy.IReagent;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentStack;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class ReagentTankTileEntity
extends AlchemyCarrierTE {
    @ObjectHolder(value="reagent_tank")
    private static TileEntityType<ReagentTankTileEntity> type = null;
    public static final int CAPACITY = 1000;
    private final LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> new AlchemyCarrierTE.ItemHandler());
    private boolean broken = false;

    public ReagentTankTileEntity() {
        super(type);
    }

    public ReagentTankTileEntity(boolean glass) {
        super(type, glass);
    }

    public float getReds() {
        return 100.0f * (float)this.contents.getTotalQty() / (float)this.transferCapacity();
    }

    @Override
    public int transferCapacity() {
        return 1000;
    }

    public ReagentMap getMap() {
        return this.contents;
    }

    public void writeContentNBT(CompoundNBT nbt) {
        this.contents = ReagentMap.readFromNBT(nbt);
        this.dirtyReag = true;
    }

    @Override
    public EnumContainerType getChannel() {
        return EnumContainerType.NONE;
    }

    @Override
    protected EnumTransferMode[] getModes() {
        return new EnumTransferMode[]{EnumTransferMode.BOTH, EnumTransferMode.BOTH, EnumTransferMode.BOTH, EnumTransferMode.BOTH, EnumTransferMode.BOTH, EnumTransferMode.BOTH};
    }

    @Override
    protected void performTransfer() {
        EnumTransferMode[] modes = this.getModes();
        for (int i = 0; i < 6; ++i) {
            IChemicalHandler otherHandler;
            LazyOptional otherOpt;
            if (!modes[i].isOutput()) continue;
            Direction side = Direction.func_82600_a((int)i);
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
            if (this.contents.getTotalQty() <= 0 || te == null || !(otherOpt = te.getCapability(Capabilities.CHEMICAL_CAPABILITY, side.func_176734_d())).isPresent() || (otherHandler = (IChemicalHandler)otherOpt.orElseThrow(NullPointerException::new)).getMode(side.func_176734_d()) == EnumTransferMode.BOTH && modes[i] == EnumTransferMode.BOTH || this.contents.getTotalQty() == 0 || !otherHandler.insertReagents(this.contents, side.func_176734_d(), this.handler)) continue;
            this.correctReag();
            this.func_70296_d();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.itemOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.CHEMICAL_CAPABILITY) {
            return this.chemOpt;
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemOpt;
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void correctReag() {
        super.correctReag();
        this.correctTemp();
        boolean destroy = false;
        ArrayList<IReagent> toRemove = new ArrayList<IReagent>(1);
        for (IReagent type : this.contents.keySet()) {
            ReagentStack reag = this.contents.getStack(type);
            if (reag.isEmpty() || !this.glass || !reag.getType().requiresCrystal()) continue;
            destroy |= reag.getType().destroysBadContainer();
            toRemove.add(type);
        }
        if (destroy) {
            this.destroyChamber();
        } else {
            for (IReagent type : toRemove) {
                this.contents.removeReagent(type, (int)((Integer)this.contents.get(type)));
            }
        }
    }

    private void destroyChamber() {
        if (!this.broken) {
            this.broken = true;
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
            SoundType sound = state.func_177230_c().getSoundType(state, (IWorldReader)this.field_145850_b, this.field_174879_c, null);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, sound.func_185845_c(), SoundCategory.BLOCKS, sound.func_185843_a(), sound.func_185847_b());
            AlchemyUtil.releaseChemical(this.field_145850_b, this.field_174879_c, this.contents);
        }
    }
}

