/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.alchemy;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.IInfoTE;
import com.Da_Technomancer.crossroads.API.alchemy.AlchemyCore;
import com.Da_Technomancer.crossroads.API.alchemy.EnumContainerType;
import com.Da_Technomancer.crossroads.API.alchemy.EnumReagents;
import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.API.alchemy.IChemicalHandler;
import com.Da_Technomancer.crossroads.API.alchemy.IReagent;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.CRConfig;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class VoltusGeneratorTileEntity
extends TileEntity
implements ITickableTileEntity,
IInfoTE {
    @ObjectHolder(value="voltus_generator")
    private static TileEntityType<VoltusGeneratorTileEntity> type = null;
    private static final int VOLTUS_CAPACITY = 100;
    private static final int FE_CAPACITY = 100000;
    private int voltusAmount = 0;
    private int fe = 0;
    private LazyOptional<IChemicalHandler> chemOpt = LazyOptional.of(() -> new AlchHandler());
    private LazyOptional<ElecHandler> feOpt = LazyOptional.of(() -> new ElecHandler());

    public VoltusGeneratorTileEntity() {
        super(type);
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.voltus_generator.read", new Object[]{this.voltusAmount, 100}));
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.voltusAmount != 0 && 100000 - this.fe <= (Integer)CRConfig.voltusValue.get()) {
            --this.voltusAmount;
            this.fe += ((Integer)CRConfig.voltusValue.get()).intValue();
            this.func_70296_d();
        }
        for (Direction dir : Direction.values()) {
            IEnergyStorage storage;
            int moved;
            LazyOptional energyOpt;
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
            if (te == null || !(energyOpt = te.getCapability(CapabilityEnergy.ENERGY, dir.func_176734_d())).isPresent() || (moved = (storage = (IEnergyStorage)energyOpt.orElseThrow(NullPointerException::new)).receiveEnergy(this.fe, false)) <= 0) continue;
            this.fe -= moved;
            this.func_70296_d();
        }
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.voltusAmount = nbt.func_74762_e("voltus");
        this.fe = nbt.func_74762_e("fe");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("voltus", this.voltusAmount);
        nbt.func_74768_a("fe", this.fe);
        return nbt;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.chemOpt.invalidate();
        this.feOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.CHEMICAL_CAPABILITY) {
            return this.chemOpt;
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.feOpt;
        }
        return super.getCapability(cap, side);
    }

    private class AlchHandler
    implements IChemicalHandler {
        private AlchHandler() {
        }

        @Override
        public EnumTransferMode getMode(Direction side) {
            return side == Direction.DOWN ? EnumTransferMode.INPUT : EnumTransferMode.NONE;
        }

        @Override
        public EnumContainerType getChannel(Direction side) {
            return EnumContainerType.CRYSTAL;
        }

        @Override
        public int getTransferCapacity() {
            return 100;
        }

        @Override
        public double getTemp() {
            return -273.0;
        }

        @Override
        public boolean insertReagents(ReagentMap reag, Direction side, IChemicalHandler caller, boolean ignorePhase) {
            if (VoltusGeneratorTileEntity.this.voltusAmount >= 100 || reag.getQty(EnumReagents.ELEM_CHARGE.id()) == 0) {
                return false;
            }
            int moved = Math.min(reag.getQty(EnumReagents.ELEM_CHARGE.id()), 100 - VoltusGeneratorTileEntity.this.voltusAmount);
            VoltusGeneratorTileEntity.this.voltusAmount += moved;
            reag.removeReagent(EnumReagents.ELEM_CHARGE.id(), moved);
            VoltusGeneratorTileEntity.this.func_70296_d();
            return true;
        }

        @Override
        public int getContent(IReagent type) {
            return type == AlchemyCore.REAGENTS.get(EnumReagents.ELEM_CHARGE.id()) ? VoltusGeneratorTileEntity.this.voltusAmount : 0;
        }
    }

    private class ElecHandler
    implements IEnergyStorage {
        private ElecHandler() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int toMove = Math.min(maxExtract, VoltusGeneratorTileEntity.this.fe);
            if (!simulate) {
                VoltusGeneratorTileEntity.this.fe -= toMove;
                VoltusGeneratorTileEntity.this.func_70296_d();
            }
            return toMove;
        }

        public int getEnergyStored() {
            return VoltusGeneratorTileEntity.this.fe;
        }

        public int getMaxEnergyStored() {
            return 100000;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return false;
        }
    }
}

