/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.beams;

import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.templates.BeamRenderTE;
import com.Da_Technomancer.crossroads.gui.container.BeamExtractorContainer;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.recipes.BeamExtractRec;
import com.Da_Technomancer.crossroads.items.technomancy.BeamCage;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class BeamExtractorTileEntity
extends BeamRenderTE
implements IInventory,
INamedContainerProvider {
    @ObjectHolder(value="beam_extractor")
    public static TileEntityType<BeamExtractorTileEntity> type = null;
    private ItemStack inv = ItemStack.field_190927_a;
    private Direction facing = null;
    private BeamUnit output = BeamUnit.EMPTY;
    private int timeRemaining = 0;
    private int timeLimit = 0;
    private LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> new ItemHandler());

    public BeamExtractorTileEntity() {
        super(type);
    }

    private Direction getFacing() {
        if (this.facing == null) {
            BlockState s = this.func_195044_w();
            if (s.func_196959_b((IProperty)ESProperties.FACING)) {
                this.facing = (Direction)s.func_177229_b((IProperty)ESProperties.FACING);
            } else {
                return Direction.DOWN;
            }
        }
        return this.facing;
    }

    public int getProgress() {
        if (this.timeLimit == 0) {
            return 0;
        }
        return 100 * this.timeRemaining / this.timeLimit;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (!this.inv.func_190926_b()) {
            nbt.func_218657_a("inv", (INBT)this.inv.func_77955_b(new CompoundNBT()));
        }
        this.output.writeToNBT("output", nbt);
        nbt.func_74768_a("remain", this.timeRemaining);
        nbt.func_74768_a("time_limit", this.timeLimit);
        return nbt;
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.inv = nbt.func_74764_b("inv") ? ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("inv")) : ItemStack.field_190927_a;
        this.output = BeamUnit.readFromNBT("output", nbt);
        this.timeRemaining = nbt.func_74762_e("remain");
        this.timeLimit = nbt.func_74762_e("time_limit");
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.itemOpt.invalidate();
    }

    @Override
    public void func_145836_u() {
        super.func_145836_u();
        this.facing = null;
        this.itemOpt.invalidate();
        this.itemOpt = LazyOptional.of(() -> new ItemHandler());
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != this.getFacing()) {
            return this.itemOpt;
        }
        return super.getCapability(capability, facing);
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        return this.inv.func_190926_b();
    }

    public ItemStack func_70301_a(int index) {
        return index == 0 ? this.inv : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index == 0) {
            this.func_70296_d();
            return this.inv.func_77979_a(count);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (index != 0) {
            return ItemStack.field_190927_a;
        }
        this.func_70296_d();
        ItemStack held = this.inv;
        this.inv = ItemStack.field_190927_a;
        return held;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index == 0) {
            this.inv = stack;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && (this.field_145850_b.func_199532_z().func_215371_a(CRRecipes.BEAM_EXTRACT_TYPE, (IInventory)new Inventory(new ItemStack[]{stack}), this.field_145850_b).isPresent() || stack.func_77973_b() == CRItems.beamCage);
    }

    public void func_174888_l() {
        this.inv = ItemStack.field_190927_a;
        this.func_70296_d();
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.beam_extractor", new Object[0]);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new BeamExtractorContainer(i, playerInventory, new PacketBuffer(Unpooled.buffer()).func_179255_a(this.field_174879_c));
    }

    @Override
    protected void doEmit(BeamUnit toEmit) {
        Direction dir = this.getFacing();
        if (!this.output.isEmpty() && this.timeRemaining > 0) {
            if (--this.timeRemaining == 0) {
                this.output = BeamUnit.EMPTY;
                this.timeLimit = 0;
                this.timeRemaining = 0;
                this.consumeFuel();
            }
            this.func_70296_d();
        } else {
            this.consumeFuel();
        }
        if (this.beamer[dir.func_176745_a()].emit(this.output, this.field_145850_b)) {
            this.refreshBeam(dir.func_176745_a());
        }
    }

    private void consumeFuel() {
        if (!this.inv.func_190926_b() && !this.field_145850_b.func_175640_z(this.field_174879_c)) {
            Optional recOpt = this.field_145850_b.func_199532_z().func_215371_a(CRRecipes.BEAM_EXTRACT_TYPE, (IInventory)this, this.field_145850_b);
            if (recOpt.isPresent()) {
                BeamExtractRec rec = (BeamExtractRec)recOpt.get();
                this.output = rec.getOutput();
                this.inv.func_190918_g(1);
                this.timeRemaining = this.timeLimit = rec.getDuration();
                this.output = rec.getOutput();
                this.func_70296_d();
            } else if (this.inv.func_77973_b() == CRItems.beamCage) {
                this.output = BeamCage.getStored(this.inv);
                BeamCage.storeBeam(this.inv, BeamUnit.EMPTY);
                this.func_70296_d();
            }
        } else {
            this.timeRemaining = 0;
            this.timeLimit = 0;
            this.output = BeamUnit.EMPTY;
        }
    }

    @Override
    protected boolean[] inputSides() {
        return new boolean[6];
    }

    @Override
    protected boolean[] outputSides() {
        boolean[] out = new boolean[6];
        out[this.getFacing().func_176745_a()] = true;
        return out;
    }

    private class ItemHandler
    implements IItemHandler {
        private ItemHandler() {
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? BeamExtractorTileEntity.this.inv : ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!BeamExtractorTileEntity.this.func_94041_b(0, stack) || stack.func_190926_b() || BeamExtractorTileEntity.this.inv.func_190916_E() >= this.getSlotLimit(0) || !BeamExtractorTileEntity.this.inv.func_190926_b() && !BeamExtractorTileEntity.this.inv.func_77969_a(stack)) {
                return stack;
            }
            int moved = Math.min(stack.func_77976_d() - BeamExtractorTileEntity.this.inv.func_190916_E(), stack.func_190916_E());
            if (!simulate) {
                if (BeamExtractorTileEntity.this.inv.func_190926_b()) {
                    BeamExtractorTileEntity.this.inv = stack.func_77946_l();
                    BeamExtractorTileEntity.this.inv.func_190920_e(moved);
                } else {
                    BeamExtractorTileEntity.this.inv.func_190917_f(moved);
                }
                BeamExtractorTileEntity.this.func_70296_d();
            }
            ItemStack output = stack.func_77946_l();
            output.func_190918_g(moved);
            return output;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0 && BeamExtractorTileEntity.this.inv.func_77973_b() == CRItems.beamCage && BeamCage.getStored(BeamExtractorTileEntity.this.inv).isEmpty()) {
                int moved = Math.min(amount, BeamExtractorTileEntity.this.inv.func_190916_E());
                if (simulate) {
                    ItemStack out = BeamExtractorTileEntity.this.inv.func_77946_l();
                    out.func_190920_e(moved);
                    return out;
                }
                BeamExtractorTileEntity.this.func_70296_d();
                return BeamExtractorTileEntity.this.inv.func_77979_a(moved);
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return BeamExtractorTileEntity.this.func_94041_b(slot, stack);
        }
    }
}

