/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.beams;

import com.Da_Technomancer.crossroads.API.CircuitUtil;
import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.templates.BeamRenderTE;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.blocks.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class BeamSiphonTileEntity
extends BeamRenderTE {
    @ObjectHolder(value="beam_siphon")
    public static TileEntityType<BeamSiphonTileEntity> type = null;
    private Direction dir = null;
    public CircuitUtil.CircHandler redsHandler = new CircuitUtil.CircHandler();
    private LazyOptional<IRedstoneHandler> redsOpt = CircuitUtil.makeBaseCircuitOptional(this, this.redsHandler, 0.0f);

    public BeamSiphonTileEntity() {
        super(type);
    }

    private Direction getDir() {
        if (this.dir == null) {
            BlockState state = this.func_195044_w();
            if (state.func_177230_c() != CRBlocks.beamSiphon) {
                return Direction.NORTH;
            }
            this.dir = (Direction)state.func_177229_b((IProperty)ESProperties.FACING);
        }
        return this.dir;
    }

    @Override
    public void func_145836_u() {
        super.func_145836_u();
        this.dir = null;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.redsHandler.write(nbt);
        return nbt;
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.redsHandler.read(nbt);
    }

    @Override
    protected void doEmit(BeamUnit out) {
        BeamUnit remain;
        BeamUnit toDraw;
        int toFill = Math.round(CircuitUtil.combineRedsSources(this.redsHandler));
        Direction facing = this.getDir();
        if (out.isEmpty() || toFill == 0) {
            toDraw = BeamUnit.EMPTY;
            remain = out;
        } else {
            toDraw = new BeamUnit(MiscUtil.withdrawExact(out.getValues(), toFill));
            remain = new BeamUnit(out.getEnergy() - toDraw.getEnergy(), out.getPotential() - toDraw.getPotential(), out.getStability() - toDraw.getStability(), out.getVoid() - toDraw.getVoid());
        }
        if (this.beamer[facing.func_176745_a()].emit(toDraw, this.field_145850_b)) {
            this.refreshBeam(facing.func_176745_a());
        }
        if (this.beamer[facing.func_176734_d().func_176745_a()].emit(remain, this.field_145850_b)) {
            this.refreshBeam(facing.func_176734_d().func_176745_a());
        }
    }

    @Override
    protected boolean[] inputSides() {
        boolean[] input = new boolean[]{true, true, true, true, true, true};
        Direction facing = this.getDir();
        input[facing.func_176745_a()] = false;
        input[facing.func_176734_d().func_176745_a()] = false;
        return input;
    }

    @Override
    protected boolean[] outputSides() {
        boolean[] output = new boolean[6];
        Direction facing = this.getDir();
        output[facing.func_176745_a()] = true;
        output[facing.func_176734_d().func_176745_a()] = true;
        return output;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.redsOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction dir) {
        if (cap == RedstoneUtil.REDSTONE_CAPABILITY) {
            return this.redsOpt;
        }
        return super.getCapability(cap, dir);
    }
}

