/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.electric;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.CRConfig;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class DynamoTileEntity
extends ModuleTE {
    @ObjectHolder(value="dynamo")
    public static TileEntityType<DynamoTileEntity> type = null;
    private static final int CHARGE_CAPACITY = 8000;
    public static final int INERTIA = 200;
    private int fe = 0;
    private LazyOptional<IEnergyStorage> feOpt = LazyOptional.of(() -> new DynamoEnergyHandler());

    public DynamoTileEntity() {
        super(type);
    }

    @Override
    protected boolean useRotary() {
        return true;
    }

    @Override
    public double getMoInertia() {
        return 200.0;
    }

    @Override
    public void func_73660_a() {
        IEnergyStorage handler;
        LazyOptional energyOpt;
        Direction facing;
        TileEntity neighbor;
        super.func_73660_a();
        int operations = (int)Math.abs(this.motData[1]);
        if (operations > 0) {
            this.motData[1] = this.motData[1] - (double)operations * Math.signum(this.motData[1]);
            this.fe += operations * (Integer)CRConfig.electPerJoule.get();
            this.fe = Math.min(this.fe, 8000);
            this.func_70296_d();
        }
        if ((neighbor = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a((facing = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)CRProperties.HORIZ_FACING)).func_176734_d()))) != null && (energyOpt = neighbor.getCapability(CapabilityEnergy.ENERGY, facing)).isPresent() && (handler = (IEnergyStorage)energyOpt.orElseThrow(NullPointerException::new)).canReceive()) {
            this.fe -= handler.receiveEnergy(this.fe, false);
            this.func_70296_d();
        }
    }

    @Override
    protected ModuleTE.AxleHandler createAxleHandler() {
        return new ModuleTE.AngleAxleHandler();
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.axleOpt.invalidate();
        this.axleOpt = LazyOptional.of(this::createAxleHandler);
        this.feOpt.invalidate();
        this.feOpt = LazyOptional.of(() -> new DynamoEnergyHandler());
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.fe = nbt.func_74762_e("charge");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("charge", this.fe);
        return nbt;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.feOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.AXLE_CAPABILITY && (side == null || side == this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)CRProperties.HORIZ_FACING))) {
            return this.axleOpt;
        }
        if (cap == CapabilityEnergy.ENERGY && (side == null || side == ((Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)CRProperties.HORIZ_FACING)).func_176734_d())) {
            return this.feOpt;
        }
        return super.getCapability(cap, side);
    }

    private class DynamoEnergyHandler
    implements IEnergyStorage {
        private DynamoEnergyHandler() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (simulate) {
                return Math.min(maxExtract, DynamoTileEntity.this.fe);
            }
            maxExtract = Math.min(maxExtract, DynamoTileEntity.this.fe);
            DynamoTileEntity.this.fe -= maxExtract;
            DynamoTileEntity.this.func_70296_d();
            return maxExtract;
        }

        public int getEnergyStored() {
            return DynamoTileEntity.this.fe;
        }

        public int getMaxEnergyStored() {
            return 8000;
        }

        public boolean canExtract() {
            return DynamoTileEntity.this.fe > 0;
        }

        public boolean canReceive() {
            return false;
        }
    }
}

