/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.electric;

import com.Da_Technomancer.crossroads.API.IInfoTE;
import com.Da_Technomancer.crossroads.blocks.electric.TeslaCoilTop;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.tileentities.electric.TeslaCoilTileEntity;
import com.Da_Technomancer.essentials.tileentities.ILinkTE;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class TeslaCoilTopTileEntity
extends TileEntity
implements IInfoTE,
ILinkTE {
    @ObjectHolder(value="tesla_coil_top")
    public static TileEntityType<TeslaCoilTopTileEntity> type = null;
    public static final int[] COLOR_CODES = new int[]{-1257473, -204801, -1281};
    private static final int[] ATTACK_COLOR_CODES = new int[]{-13108, -52, -1286};
    private HashSet<BlockPos> linked = new HashSet(3);
    private TeslaCoilTop.TeslaCoilVariants variant = null;

    public TeslaCoilTopTileEntity() {
        super(type);
    }

    private TeslaCoilTop.TeslaCoilVariants getVariant() {
        if (this.variant == null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() instanceof TeslaCoilTop) {
                this.variant = ((TeslaCoilTop)state.func_177230_c()).variant;
            } else {
                this.func_145843_s();
                return TeslaCoilTop.TeslaCoilVariants.NORMAL;
            }
        }
        return this.variant;
    }

    public void receiveLong(byte identifier, long message, @Nullable ServerPlayerEntity sendingPlayer) {
        if (identifier == 8) {
            this.linked.add(BlockPos.func_218283_e((long)message));
        } else if (identifier == 9) {
            this.linked.clear();
        }
    }

    protected void jolt(TeslaCoilTileEntity coilTE) {
        block6: {
            int joltQty;
            int range;
            TeslaCoilTop.TeslaCoilVariants variant;
            block8: {
                block7: {
                    variant = this.getVariant();
                    range = variant.range;
                    joltQty = variant.joltAmt;
                    if (variant != TeslaCoilTop.TeslaCoilVariants.ATTACK) break block7;
                    if (this.field_145850_b.field_72995_K) {
                        return;
                    }
                    List ents = this.field_145850_b.func_175647_a(LivingEntity.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - range), (double)(this.field_174879_c.func_177956_o() - range), (double)(this.field_174879_c.func_177952_p() - range), (double)(this.field_174879_c.func_177958_n() + range), (double)(this.field_174879_c.func_177956_o() + range), (double)(this.field_174879_c.func_177952_p() + range)), EntityPredicates.field_94557_a);
                    if (ents.isEmpty() || coilTE.getStored() < joltQty) break block6;
                    LivingEntity ent = (LivingEntity)ents.get(this.field_145850_b.field_73012_v.nextInt(ents.size()));
                    coilTE.setStored(coilTE.getStored() - joltQty);
                    this.func_70296_d();
                    CRRenderUtil.addArc(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.75f, (float)this.field_174879_c.func_177952_p() + 0.5f, (float)ent.func_226277_ct_(), (float)ent.func_226278_cu_(), (float)ent.func_226281_cx_(), 5, 0.2f, ATTACK_COLOR_CODES[(int)(this.field_145850_b.func_82737_E() % 3L)]);
                    ent.func_70077_a(new LightningBoltEntity(this.field_145850_b, ent.func_226277_ct_(), ent.func_226278_cu_(), ent.func_226281_cx_(), true));
                    break block6;
                }
                if (variant != TeslaCoilTop.TeslaCoilVariants.DECORATIVE) break block8;
                if (coilTE.getStored() < TeslaCoilTop.TeslaCoilVariants.DECORATIVE.joltAmt) break block6;
                if (this.field_145850_b.field_72995_K) {
                    int count = this.field_145850_b.field_73012_v.nextInt(5) + 1;
                    Vec3d start = new Vec3d((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.75f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f));
                    for (int i = 0; i < count; ++i) {
                        float angle = this.field_145850_b.field_73012_v.nextFloat() * 2.0f * (float)Math.PI;
                        float rad = this.field_145850_b.field_73012_v.nextFloat() * 2.0f + 3.0f;
                        Vec3d end = start.func_178787_e(new Vec3d((double)rad * Math.cos(angle), (double)(this.field_145850_b.field_73012_v.nextFloat() * 2.0f - 1.0f), (double)rad * Math.sin(angle)));
                        CRRenderUtil.addArc(this.field_145850_b, start, end, 6, 0.6f, COLOR_CODES[this.field_145850_b.field_73012_v.nextInt(COLOR_CODES.length)]);
                    }
                } else {
                    coilTE.setStored(coilTE.getStored() - TeslaCoilTop.TeslaCoilVariants.DECORATIVE.joltAmt);
                }
                break block6;
            }
            if (!this.field_145850_b.field_72995_K) {
                for (BlockPos linkPos : this.linked) {
                    TeslaCoilTileEntity tcTe;
                    BlockPos actualPos;
                    TileEntity te;
                    if (linkPos == null || coilTE.getStored() < joltQty || !(linkPos.func_218140_a(0.0, 0.0, 0.0, false) <= (double)(range * range)) || !((te = this.field_145850_b.func_175625_s(actualPos = linkPos.func_177982_a(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()))) instanceof TeslaCoilTileEntity) || !(this.field_145850_b.func_175625_s(actualPos.func_177984_a()) instanceof TeslaCoilTopTileEntity) || !((double)((tcTe = (TeslaCoilTileEntity)te).getCapacity() - tcTe.getStored()) > (double)joltQty * (double)variant.efficiency / 100.0)) continue;
                    tcTe.setStored(tcTe.getStored() + (int)((double)joltQty * (double)variant.efficiency / 100.0));
                    tcTe.func_70296_d();
                    coilTE.setStored(coilTE.getStored() - joltQty);
                    this.func_70296_d();
                    CRRenderUtil.addArc(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.75f, (float)this.field_174879_c.func_177952_p() + 0.5f, (float)actualPos.func_177958_n() + 0.5f, (float)actualPos.func_177956_o() + 1.75f, (float)actualPos.func_177952_p() + 0.5f, 5, (100.0f - (float)variant.efficiency) / 100.0f, COLOR_CODES[(int)(this.field_145850_b.func_82737_E() % 3L)]);
                    break;
                }
            }
        }
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        for (BlockPos link : this.linked) {
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.link", new Object[]{this.field_174879_c.func_177958_n() + link.func_177958_n(), this.field_174879_c.func_177956_o() + link.func_177956_o(), this.field_174879_c.func_177952_p() + link.func_177952_p()}));
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        int count = 0;
        for (BlockPos relPos : this.linked) {
            nbt.func_74772_a("link" + count++, relPos.func_218275_a());
        }
        return nbt;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        int count = 0;
        while (nbt.func_74764_b("link" + count)) {
            this.linked.add(BlockPos.func_218283_e((long)nbt.func_74763_f("link" + count)));
            ++count;
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        int count = 0;
        for (BlockPos relPos : this.linked) {
            nbt.func_74772_a("link" + count++, relPos.func_218275_a());
        }
        return nbt;
    }

    public TileEntity getTE() {
        return this;
    }

    public boolean canBeginLinking() {
        return this.getVariant() != TeslaCoilTop.TeslaCoilVariants.ATTACK && this.getVariant() != TeslaCoilTop.TeslaCoilVariants.DECORATIVE;
    }

    public boolean canLink(ILinkTE otherTE) {
        return otherTE instanceof TeslaCoilTopTileEntity && this.getVariant() != TeslaCoilTop.TeslaCoilVariants.ATTACK;
    }

    public HashSet<BlockPos> getLinks() {
        return this.linked;
    }

    public int getRange() {
        return this.getVariant().range;
    }
}

