/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.heat;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.gui.container.FluidCoolerContainer;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.recipes.FluidCoolingRec;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class FluidCoolingChamberTileEntity
extends InventoryTE {
    @ObjectHolder(value="fluid_cooling_chamber")
    private static TileEntityType<FluidCoolingChamberTileEntity> type = null;
    public static final int HEATING_RATE = 40;
    private double storedHeat = 0.0;
    private final LazyOptional<InventoryTE.ItemHandler> itemOpt = LazyOptional.of(() -> new InventoryTE.ItemHandler());

    public FluidCoolingChamberTileEntity() {
        super(type, 1);
        this.fluidProps[0] = new ModuleTE.TankProperty(4000, true, false, o -> true);
        this.initFluidManagers();
    }

    @Override
    protected int fluidTanks() {
        return 1;
    }

    @Override
    protected boolean useHeat() {
        return true;
    }

    public FluidStack getFluid() {
        return this.fluids[0];
    }

    @Override
    public void func_73660_a() {
        List recipes;
        Optional<FluidCoolingRec> recOpt;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        double moved = Math.min(this.storedHeat, 40.0);
        if (moved > 0.0) {
            this.storedHeat -= moved;
            this.temp += moved;
            this.func_70296_d();
        }
        if ((recOpt = (recipes = this.field_145850_b.func_199532_z().func_215370_b(CRRecipes.FLUID_COOLING_TYPE, (IInventory)this, this.field_145850_b)).parallelStream().filter(rec -> (double)rec.getMaxTemp() > this.temp + this.storedHeat && BlockUtil.sameFluid((FluidStack)rec.getInput(), (FluidStack)this.fluids[0]) && rec.getInput().getAmount() <= this.fluids[0].getAmount() && (this.inventory[0].func_190926_b() || BlockUtil.sameItem((ItemStack)this.inventory[0], (ItemStack)rec.func_77571_b()))).findFirst()).isPresent()) {
            FluidCoolingRec rec2 = recOpt.get();
            if (this.inventory[0].func_77976_d() - this.inventory[0].func_190916_E() >= rec2.func_77571_b().func_190916_E()) {
                this.storedHeat += (double)rec2.getAddedHeat();
                this.fluids[0].shrink(rec2.getInput().getAmount());
                if (this.inventory[0].func_190926_b()) {
                    this.inventory[0] = rec2.func_77572_b((IInventory)this);
                } else {
                    this.inventory[0].func_190917_f(rec2.func_77571_b().func_190916_E());
                }
                this.func_70296_d();
            }
        }
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.storedHeat = nbt.func_74769_h("heat_stored");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74780_a("heat_stored", this.storedHeat);
        return nbt;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.itemOpt.invalidate();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction dir) {
        if (cap == Capabilities.HEAT_CAPABILITY && dir == Direction.UP) {
            return this.heatOpt;
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemOpt;
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.globalFluidOpt;
        }
        return super.getCapability(cap, dir);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.fluid_cooler", new Object[0]);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new FluidCoolerContainer(id, playerInventory, this.createContainerBuf());
    }
}

