/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.rotary;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.rotary.IAxisHandler;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.gui.container.StampMillContainer;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.recipes.StampMillRec;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class StampMillTileEntity
extends InventoryTE {
    @ObjectHolder(value="stamp_mill")
    public static TileEntityType<StampMillTileEntity> type = null;
    public static final int TIME_LIMIT = 100;
    public static final int INERTIA = 200;
    public static final double REQUIRED = 800.0;
    public static final double PROGRESS_PER_RADIAN = 20.0;
    private double progress = 0.0;
    private int timer = 0;
    private final LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> new InventoryTE.ItemHandler());
    private static final AxisAlignedBB RENDER_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);

    public StampMillTileEntity() {
        super(type, 2);
    }

    public int getProgress() {
        return (int)Math.round(this.progress);
    }

    public int getTimer() {
        return this.timer;
    }

    @Override
    protected boolean useRotary() {
        return true;
    }

    @Override
    protected ModuleTE.AxleHandler createAxleHandler() {
        return new ThroughAxleHandler();
    }

    public float renderAngle(float partialTicks) {
        float prev = this.axleHandler.getAngle(partialTicks - 1.0f);
        float cur = this.axleHandler.getAngle(partialTicks);
        return Math.signum(cur - prev) * cur;
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.progress", new Object[]{(int)this.progress, 800}));
        super.addInfo(chat, player, hit);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            BlockState state = this.func_195044_w();
            if (state.func_177230_c() != CRBlocks.stampMill) {
                return;
            }
            double progChange = Math.min(Math.abs(this.motData[1]), Math.min(800.0 - this.progress, 20.0 * Math.abs(this.motData[0]) / 20.0));
            this.motData[1] = this.motData[1] - Math.signum(this.motData[1]) * progChange;
            if (this.inventory[1].func_190926_b() && !this.inventory[0].func_190926_b()) {
                this.progress += progChange;
                if (++this.timer >= 100 || this.progress >= 800.0) {
                    this.timer = 0;
                    if (this.progress >= 800.0) {
                        ItemStack produced;
                        this.progress = 0.0;
                        this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187692_g, SoundCategory.BLOCKS, 1.0f, this.field_145850_b.field_73012_v.nextFloat(), true);
                        Optional recOpt = this.field_145850_b.func_199532_z().func_215371_a(CRRecipes.STAMP_MILL_TYPE, (IInventory)this, this.field_145850_b);
                        if (recOpt.isPresent()) {
                            produced = ((StampMillRec)recOpt.get()).func_77571_b();
                            produced = produced.func_77946_l();
                        } else {
                            produced = this.inventory[0].func_77946_l();
                            produced.func_190920_e(1);
                        }
                        this.inventory[0].func_190918_g(1);
                        this.inventory[1] = produced;
                    } else {
                        this.inventory[1] = this.inventory[0].func_77979_a(1);
                        this.progress -= 800.0 * (double)((Integer)CRConfig.stampMillDamping.get()).intValue() / 100.0;
                        if (this.progress < 0.0) {
                            this.progress = 0.0;
                        }
                    }
                }
                this.func_70296_d();
            }
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74780_a("prog", this.progress);
        nbt.func_74768_a("timer", this.timer);
        return nbt;
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74769_h("prog");
        this.timer = nbt.func_74762_e("timer");
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.itemOpt.invalidate();
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.axleOpt.invalidate();
        this.axleOpt = LazyOptional.of(() -> this.axleHandler);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemOpt;
        }
        BlockState state = this.func_195044_w();
        if (state.func_177230_c() == CRBlocks.stampMill && cap == Capabilities.AXLE_CAPABILITY && (side == null || side.func_176740_k() == state.func_177229_b(CRProperties.HORIZ_AXIS))) {
            return this.axleOpt;
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new StampMillContainer(id, playerInv, this.createContainerBuf());
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && this.field_145850_b.func_199532_z().func_215371_a(CRRecipes.STAMP_MILL_TYPE, (IInventory)new Inventory(new ItemStack[]{stack}), this.field_145850_b).isPresent();
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.stamp_mill", new Object[0]);
    }

    @Override
    public double getMoInertia() {
        return 200.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return RENDER_BOX.func_186670_a(this.field_174879_c);
    }

    private class ThroughAxleHandler
    extends ModuleTE.AngleAxleHandler {
        private ThroughAxleHandler() {
        }

        @Override
        public void propogate(IAxisHandler masterIn, byte key, double rotRatioIn, double lastRadius, boolean renderOffset) {
            if (key == this.updateKey || masterIn.addToList(this)) {
                return;
            }
            this.rotRatio = rotRatioIn == 0.0 ? 1.0 : rotRatioIn;
            this.updateKey = key;
            this.axis = masterIn;
            BlockState state = StampMillTileEntity.this.func_195044_w();
            if (state.func_177230_c() != CRBlocks.stampMill) {
                return;
            }
            Direction.Axis ax = (Direction.Axis)state.func_177229_b(CRProperties.HORIZ_AXIS);
            for (Direction.AxisDirection dir : Direction.AxisDirection.values()) {
                LazyOptional oAxleOpt;
                Direction side = Direction.func_181076_a((Direction.AxisDirection)dir, (Direction.Axis)ax);
                TileEntity te = StampMillTileEntity.this.field_145850_b.func_175625_s(StampMillTileEntity.this.field_174879_c.func_177972_a(side));
                if (te == null) continue;
                LazyOptional axisOpt = te.getCapability(Capabilities.AXIS_CAPABILITY, side.func_176734_d());
                if (axisOpt.isPresent()) {
                    ((IAxisHandler)axisOpt.orElseThrow(NullPointerException::new)).trigger(masterIn, key);
                }
                if (!(oAxleOpt = te.getCapability(Capabilities.AXLE_CAPABILITY, side.func_176734_d())).isPresent()) continue;
                ((IAxleHandler)oAxleOpt.orElseThrow(NullPointerException::new)).propogate(masterIn, key, rotRatioIn, lastRadius, renderOffset);
            }
        }
    }
}

