/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.rotary;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class WindTurbineTileEntity
extends ModuleTE {
    @ObjectHolder(value="wind_turbine")
    public static TileEntityType<WindTurbineTileEntity> type = null;
    public static final double MAX_SPEED = 2.0;
    public static final double INERTIA = 200.0;
    public static final double POWER_PER_LEVEL = 10.0;
    private static final HashSet<String> murderEasterEgg = new HashSet(12);
    private boolean newlyPlaced = true;
    private int level = 1;
    private boolean running = false;
    private AxisAlignedBB targetBB = null;
    private static final AxisAlignedBB RENDER_BOX;

    public WindTurbineTileEntity() {
        super(type);
    }

    public WindTurbineTileEntity(boolean newlyPlaced) {
        this();
        this.newlyPlaced = newlyPlaced;
    }

    protected Direction getFacing() {
        BlockState state = this.func_195044_w();
        if (state.func_177230_c() != CRBlocks.windTurbine) {
            this.func_145843_s();
            return Direction.NORTH;
        }
        return (Direction)state.func_177229_b((IProperty)CRProperties.HORIZ_FACING);
    }

    private AxisAlignedBB getTargetBB() {
        if (this.targetBB == null) {
            Direction dir = this.getFacing();
            Direction planeDir = dir.func_176746_e();
            if (planeDir.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
                planeDir = planeDir.func_176734_d();
            }
            BlockPos center = this.field_174879_c.func_177972_a(dir);
            this.targetBB = dir.func_176743_c() == Direction.AxisDirection.POSITIVE ? new AxisAlignedBB(center.func_177967_a(planeDir, -2).func_177967_a(Direction.DOWN, 2), center.func_177967_a(planeDir, 3).func_177967_a(Direction.UP, 3).func_177972_a(dir)) : new AxisAlignedBB(center.func_177967_a(planeDir, -2).func_177967_a(Direction.DOWN, 2), center.func_177967_a(planeDir, 3).func_177967_a(Direction.UP, 3).func_177967_a(dir, -1));
        }
        return this.targetBB;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.axleOpt.invalidate();
        this.axleOpt = LazyOptional.of(() -> this.axleHandler);
        this.newlyPlaced = true;
        this.targetBB = null;
    }

    @Override
    protected boolean useRotary() {
        return true;
    }

    @Override
    protected ModuleTE.AxleHandler createAxleHandler() {
        return new ModuleTE.AngleAxleHandler();
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.wind_turbine.weather", new Object[]{10.0 * (double)this.level}));
        super.addInfo(chat, player, hit);
    }

    public float getRedstoneOutput() {
        return (float)(20.0 + (double)this.level * 10.0);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.newlyPlaced || this.field_145850_b.func_82737_E() % 600L == 0L) {
                this.newlyPlaced = false;
                this.running = false;
                Direction facing = this.getFacing();
                BlockPos offsetPos = this.field_174879_c.func_177972_a(facing);
                if (this.field_145850_b.func_175710_j(offsetPos)) {
                    this.running = true;
                    block0: for (int i = -2; i <= 2; ++i) {
                        for (int j = -2; j <= 2; ++j) {
                            BlockPos checkPos = offsetPos.func_177982_a(facing.func_82599_e() * i, j, facing.func_82601_c() * i);
                            BlockState checkState = this.field_145850_b.func_180495_p(checkPos);
                            if (checkState.func_177230_c().isAir(checkState, (IBlockReader)this.field_145850_b, checkPos)) continue;
                            this.running = false;
                            break block0;
                        }
                    }
                }
                this.func_70296_d();
            }
            if (this.running && this.axleHandler.axis != null) {
                if (this.field_145850_b.func_82737_E() % 10L == 0L && this.field_145850_b.field_73012_v.nextInt(240) == 0) {
                    this.level = (this.field_145850_b.field_73012_v.nextInt(2) + 1) * (this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1);
                }
                if (this.motData[0] * (double)Math.signum(this.level) < 2.0) {
                    this.motData[1] = this.motData[1] + (double)this.level * 10.0;
                }
                if (Math.abs(this.motData[0]) >= 1.5) {
                    List ents = this.field_145850_b.func_175647_a(LivingEntity.class, this.getTargetBB(), EntityPredicates.field_212545_b);
                    for (LivingEntity ent : ents) {
                        if (ent instanceof PlayerEntity && murderEasterEgg.contains(((PlayerEntity)ent).func_146103_bH().getName())) {
                            ent.func_70097_a(DamageSource.field_188406_j, 100.0f);
                            continue;
                        }
                        ent.func_70097_a(DamageSource.field_188406_j, 1.0f);
                    }
                }
                this.func_70296_d();
            }
        }
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.level = nbt.func_74762_e("level");
        this.running = nbt.func_74767_n("running");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("level", this.level);
        nbt.func_74757_a("running", this.running);
        return nbt;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return RENDER_BOX.func_186670_a(this.field_174879_c);
    }

    @Override
    public double getMoInertia() {
        return 200.0;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == Capabilities.AXLE_CAPABILITY && (facing == null || facing == this.getFacing().func_176734_d())) {
            return this.axleOpt;
        }
        return super.getCapability(capability, facing);
    }

    static {
        murderEasterEgg.add("dinidini");
        RENDER_BOX = new AxisAlignedBB(-1.0, -1.0, -1.0, 2.0, 2.0, 2.0);
    }
}

